/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.nightcore.util.random;

import java.util.Random;

public class MTRandom
extends Random {
    private static final int UPPER_MASK = Integer.MIN_VALUE;
    private static final int LOWER_MASK = Integer.MAX_VALUE;
    private static final int N = 624;
    private static final int M = 397;
    private static final int[] MAGIC = new int[]{0, -1727483681};
    private static final int MAGIC_FACTOR1 = 1812433253;
    private static final int MAGIC_FACTOR2 = 1664525;
    private static final int MAGIC_FACTOR3 = 1566083941;
    private static final int MAGIC_MASK1 = -1658038656;
    private static final int MAGIC_MASK2 = -272236544;
    private static final int MAGIC_SEED = 19650218;
    private transient int[] mt;
    private transient int mti;
    private transient int[] ibuf;

    private void setSeed() {
        if (this.mt == null) {
            this.mt = new int[624];
        }
        this.mt[0] = 19650218;
        this.mti = 1;
        while (this.mti < 624) {
            this.mt[this.mti] = 1812433253 * (this.mt[this.mti - 1] ^ this.mt[this.mti - 1] >>> 30) + this.mti;
            ++this.mti;
        }
    }

    @Override
    public final synchronized void setSeed(long seed) {
        if (this.ibuf == null) {
            this.ibuf = new int[2];
        }
        this.ibuf[0] = (int)seed;
        this.ibuf[1] = (int)(seed >>> 32);
        this.setSeed(this.ibuf);
    }

    @Override
    protected final synchronized int next(int bits) {
        int y;
        if (this.mti >= 624) {
            int kk;
            for (kk = 0; kk < 227; ++kk) {
                y = this.mt[kk] & Integer.MIN_VALUE | this.mt[kk + 1] & Integer.MAX_VALUE;
                this.mt[kk] = this.mt[kk + 397] ^ y >>> 1 ^ MAGIC[y & 1];
            }
            while (kk < 623) {
                y = this.mt[kk] & Integer.MIN_VALUE | this.mt[kk + 1] & Integer.MAX_VALUE;
                this.mt[kk] = this.mt[kk + -227] ^ y >>> 1 ^ MAGIC[y & 1];
                ++kk;
            }
            y = this.mt[623] & Integer.MIN_VALUE | this.mt[0] & Integer.MAX_VALUE;
            this.mt[623] = this.mt[396] ^ y >>> 1 ^ MAGIC[y & 1];
            this.mti = 0;
        }
        y = this.mt[this.mti++];
        y ^= y >>> 11;
        y ^= y << 7 & 0x9D2C5680;
        y ^= y << 15 & 0xEFC60000;
        y ^= y >>> 18;
        return y >>> 32 - bits;
    }

    public final synchronized void setSeed(int[] buf) {
        int k;
        int length = buf.length;
        if (length == 0) {
            throw new IllegalArgumentException("Seed buffer may not be empty");
        }
        int i = 1;
        int j = 0;
        this.setSeed();
        for (k = Math.max(624, length); k > 0; --k) {
            this.mt[i] = (this.mt[i] ^ (this.mt[i - 1] ^ this.mt[i - 1] >>> 30) * 1664525) + buf[j] + j;
            ++j;
            if (++i >= 624) {
                this.mt[0] = this.mt[623];
                i = 1;
            }
            if (j < length) continue;
            j = 0;
        }
        for (k = 623; k > 0; --k) {
            this.mt[i] = (this.mt[i] ^ (this.mt[i - 1] ^ this.mt[i - 1] >>> 30) * 1566083941) - i;
            if (++i < 624) continue;
            this.mt[0] = this.mt[623];
            i = 1;
        }
        this.mt[0] = Integer.MIN_VALUE;
    }
}

