/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.nightcore.user;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.NightPlugin;
import su.nightexpress.nightcore.manager.AbstractManager;
import su.nightexpress.nightcore.user.UserTemplate;
import su.nightexpress.nightcore.user.cache.UserRepository;
import su.nightexpress.nightcore.user.data.UserDataAccessor;
import su.nightexpress.nightcore.user.data.UserDataSettings;
import su.nightexpress.nightcore.user.listener.UserListener;
import su.nightexpress.nightcore.util.Players;

public abstract class AbstractUserManager<P extends NightPlugin, U extends UserTemplate>
extends AbstractManager<P> {
    protected final UserDataAccessor<U> dataAccessor;
    protected final UserRepository<U> repository;
    protected final UserDataSettings settings;

    public AbstractUserManager(@NotNull P plugin, @NotNull UserDataAccessor<U> dataAccessor) {
        super(plugin);
        this.dataAccessor = dataAccessor;
        this.repository = new UserRepository();
        this.settings = new UserDataSettings();
    }

    @Override
    protected void onLoad() {
        this.settings.load(((NightPlugin)this.plugin).getEngineConfig());
        this.addListener(new UserListener((NightPlugin)this.plugin, this));
        this.addAsyncTask(this::saveDirty, this.settings.getSaveInterval());
        this.addAsyncTask(this.repository::cleanExpired, this.settings.getCacheCleanupInterval());
        ((NightPlugin)this.plugin).runTaskAsync(task -> this.dataAccessor.loadProfiles().forEach(userInfo -> this.repository.addNameIdMapping(userInfo.name(), userInfo.id())));
        ((NightPlugin)this.plugin).onPostLoad(() -> {
            this.loadOnline();
            this.dataAccessor.addSynchronization(this::synchronizeUserData);
        });
    }

    @Override
    protected void onShutdown() {
        this.saveDirty();
        this.repository.clear();
    }

    private void loadOnline() {
        Players.getOnline().stream().map(Entity::getUniqueId).map(this::getOrFetch).filter(Optional::isPresent).map(Optional::get).forEach(this::cachePermanent);
    }

    private void synchronizeUserData(@NotNull U user) {
        if (!this.repository.contains(((UserTemplate)user).getId())) {
            this.cacheTemporary(user);
            return;
        }
        this.repository.getById(((UserTemplate)user).getId()).ifPresent(cached -> this.synchronize(user, cached));
    }

    @NotNull
    protected abstract U create(@NotNull UUID var1, @NotNull String var2, @NotNull InetAddress var3);

    protected abstract void synchronize(@NotNull U var1, @NotNull U var2);

    @NotNull
    public UserDataAccessor<U> getDataAccessor() {
        return this.dataAccessor;
    }

    @NotNull
    public UserRepository<U> getRepository() {
        return this.repository;
    }

    private void cacheTemporary(@NotNull U user) {
        this.repository.addTemporary(user, this.settings.getCacheLifetime());
    }

    private void cachePermanent(@NotNull U user) {
        this.repository.addPermanent(user);
    }

    public final void handlePreLogin(@NotNull AsyncPlayerPreLoginEvent event) {
        if (event.getLoginResult() != AsyncPlayerPreLoginEvent.Result.ALLOWED) {
            return;
        }
        UUID uuid = event.getUniqueId();
        if (!this.dataAccessor.isExists(uuid)) {
            U user = this.create(uuid, event.getName(), event.getAddress());
            this.dataAccessor.insert(user);
            this.cacheTemporary(user);
            return;
        }
        this.getOrFetch(uuid);
    }

    public final void handleJoin(@NotNull PlayerJoinEvent event) {
        Player player = event.getPlayer();
        this.repository.getById(player.getUniqueId()).ifPresent(user -> {
            user.setName(player.getName());
            this.cachePermanent(user);
        });
    }

    public final void handleQuit(@NotNull PlayerQuitEvent event) {
        Player player = event.getPlayer();
        this.repository.getById(player.getUniqueId()).ifPresent(user -> {
            if (user.isDirty()) {
                ((NightPlugin)this.plugin).runTaskAsync(task -> this.dataAccessor.update((UserTemplate)user));
                user.markClean();
            } else {
                ((NightPlugin)this.plugin).runTaskAsync(task -> this.dataAccessor.tinyUpdate((UserTemplate)user));
            }
            this.cacheTemporary(user);
        });
    }

    public void saveDirty() {
        Set users = this.repository.getAll().stream().filter(UserTemplate::isDirty).peek(UserTemplate::markClean).collect(Collectors.toSet());
        if (users.isEmpty()) {
            return;
        }
        this.dataAccessor.update(users);
    }

    @NotNull
    public final U getOrFetch(@NotNull Player player) {
        UUID uuid = player.getUniqueId();
        UserTemplate byId = this.repository.getById(uuid).orElse(null);
        if (byId != null) {
            return (U)byId;
        }
        UserTemplate fromDb = this.dataAccessor.loadById(uuid).orElse(null);
        if (fromDb != null) {
            ((NightPlugin)this.plugin).warn("User data for '%s' was present, but not loaded.");
            this.cachePermanent(fromDb);
            return (U)fromDb;
        }
        InetAddress address = Optional.ofNullable(player.getAddress()).map(InetSocketAddress::getAddress).orElse(null);
        if (address == null) {
            throw new IllegalStateException("%s is not a real player?".formatted(player));
        }
        return this.create(uuid, player.getName(), address);
    }

    @NotNull
    public final Optional<U> getOrFetch(@NotNull String name) {
        Player player = Players.getPlayer(name);
        if (player != null) {
            return this.getOrFetch(player.getUniqueId());
        }
        Optional<U> byName = this.repository.getByName(name);
        if (byName.isPresent()) {
            return byName;
        }
        Optional<U> fromDb = this.dataAccessor.loadByName(name);
        if (fromDb.isPresent()) {
            this.cacheTemporary((UserTemplate)fromDb.get());
            return fromDb;
        }
        return Optional.empty();
    }

    @NotNull
    public final Optional<U> getOrFetch(@NotNull UUID uuid) {
        Optional<U> byName = this.repository.getById(uuid);
        if (byName.isPresent()) {
            return byName;
        }
        Optional<U> fromDb = this.dataAccessor.loadById(uuid);
        if (fromDb.isPresent()) {
            this.cacheTemporary((UserTemplate)fromDb.get());
            return fromDb;
        }
        return Optional.empty();
    }

    @NotNull
    public final CompletableFuture<Optional<U>> loadByIdAsync(@NotNull UUID uuid) {
        return CompletableFuture.supplyAsync(() -> this.getOrFetch(uuid));
    }

    @NotNull
    public final CompletableFuture<Optional<U>> loadByNameAsync(@NotNull String name) {
        return CompletableFuture.supplyAsync(() -> this.getOrFetch(name));
    }

    @NotNull
    public Set<U> getAll() {
        Set<U> users = this.repository.getAll();
        this.dataAccessor.loadAll().stream().filter(user -> !this.repository.contains(user.getId())).forEach(users::add);
        return users;
    }
}

