/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.nightcore.db.column;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@FunctionalInterface
public interface ColumnDataReader<R> {
    public static final ColumnDataReader<Boolean> BOOLEAN = ResultSet::getBoolean;
    public static final ColumnDataReader<Integer> INTEGER = ResultSet::getInt;
    public static final ColumnDataReader<Long> LONG = ResultSet::getLong;
    public static final ColumnDataReader<Float> FLOAT = ResultSet::getFloat;
    public static final ColumnDataReader<Double> DOUBLE = ResultSet::getDouble;
    public static final ColumnDataReader<String> STRING = ResultSet::getString;
    public static final ColumnDataReader<UUID> UUID = (resultSet, column) -> {
        String raw = resultSet.getString(column);
        if (resultSet.wasNull()) {
            return null;
        }
        try {
            return java.util.UUID.fromString(raw);
        }
        catch (IllegalArgumentException exception) {
            return null;
        }
    };

    @NotNull
    public static <V> ColumnDataReader<V> jsonObject(@NotNull Gson gson, @NotNull Class<V> type) {
        return (resultSet, column) -> {
            String jsonString = resultSet.getString(column);
            if (resultSet.wasNull() || jsonString == null) {
                return null;
            }
            return gson.fromJson(jsonString, type);
        };
    }

    @NotNull
    public static <K, V> ColumnDataReader<Map<K, V>> jsonMap(@NotNull Gson gson, @NotNull Class<K> keyType, @NotNull Class<V> valType) {
        return (resultSet, column) -> {
            String jsonString = resultSet.getString(column);
            if (resultSet.wasNull() || jsonString == null) {
                return null;
            }
            Type mapType = TypeToken.getParameterized(Map.class, (Type[])new Type[]{keyType, valType}).getType();
            return (Map)gson.fromJson(jsonString, mapType);
        };
    }

    @NotNull
    public static <V> ColumnDataReader<List<V>> jsonList(@NotNull Gson gson, @NotNull Class<V> valType) {
        return (resultSet, column) -> {
            String jsonString = resultSet.getString(column);
            if (resultSet.wasNull() || jsonString == null) {
                return null;
            }
            Type mapType = TypeToken.getParameterized(List.class, (Type[])new Type[]{valType}).getType();
            return (List)gson.fromJson(jsonString, mapType);
        };
    }

    @Nullable
    public R readPrimitive(@NotNull ResultSet var1, @NotNull String var2) throws SQLException;

    @NotNull
    default public Optional<R> read(@NotNull ResultSet resultSet, @NotNull String column) throws SQLException {
        R primitive = this.readPrimitive(resultSet, column);
        return primitive == null || resultSet.wasNull() ? Optional.empty() : Optional.of(primitive);
    }
}

