/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.nightcore.bridge.paper;

import com.destroystokyo.paper.profile.PlayerProfile;
import io.papermc.paper.datacomponent.DataComponentType;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.TooltipDisplay;
import java.time.Duration;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.dialog.DialogLike;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.title.Title;
import net.kyori.adventure.translation.Translatable;
import net.kyori.adventure.util.Ticks;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.attribute.Attribute;
import org.bukkit.command.Command;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerPreLoginEvent;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MenuType;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.nightcore.bridge.bossbar.NightBarColor;
import su.nightexpress.nightcore.bridge.bossbar.NightBarFlag;
import su.nightexpress.nightcore.bridge.bossbar.NightBarOverlay;
import su.nightexpress.nightcore.bridge.chat.UniversalChatListenerCallback;
import su.nightexpress.nightcore.bridge.dialog.adapter.DialogAdapter;
import su.nightexpress.nightcore.bridge.dialog.response.DialogClickHandler;
import su.nightexpress.nightcore.bridge.dialog.wrap.WrappedDialog;
import su.nightexpress.nightcore.bridge.paper.PaperProfile;
import su.nightexpress.nightcore.bridge.paper.bossbar.PaperBossBar;
import su.nightexpress.nightcore.bridge.paper.bossbar.PaperBossBarAdapter;
import su.nightexpress.nightcore.bridge.paper.dialog.PaperDialogAdapter;
import su.nightexpress.nightcore.bridge.paper.dialog.PaperDialogListener;
import su.nightexpress.nightcore.bridge.paper.event.PaperChatListener;
import su.nightexpress.nightcore.bridge.paper.event.PaperEventAdapter;
import su.nightexpress.nightcore.bridge.paper.text.PaperTextComponentAdapter;
import su.nightexpress.nightcore.bridge.wrap.NightProfile;
import su.nightexpress.nightcore.util.BukkitThing;
import su.nightexpress.nightcore.util.Lists;
import su.nightexpress.nightcore.util.Version;
import su.nightexpress.nightcore.util.bridge.RegistryType;
import su.nightexpress.nightcore.util.bridge.Software;
import su.nightexpress.nightcore.util.bridge.wrapper.NightComponent;

public class PaperBridge
implements Software {
    private DialogAdapter<?> dialogAdapter;
    private PaperTextComponentAdapter textComponentAdapter;
    private PaperEventAdapter eventAdapter;
    private Set<DataComponentType> commonComponentsToHide;

    @Override
    @NotNull
    public String getName() {
        return "paper-bridge";
    }

    @Override
    public boolean isPaper() {
        return true;
    }

    @Override
    public boolean initialize() {
        this.textComponentAdapter = new PaperTextComponentAdapter(this);
        if (Version.isAtLeast(Version.MC_1_21_7)) {
            this.dialogAdapter = new PaperDialogAdapter(this);
        }
        if (Version.isAtLeast(Version.MC_1_21_5)) {
            this.commonComponentsToHide = BukkitThing.getAll(RegistryType.Paper.DATA_COMPONENT_TYPE);
            this.commonComponentsToHide.remove(DataComponentTypes.LORE);
            this.commonComponentsToHide.remove(DataComponentTypes.ITEM_NAME);
            this.commonComponentsToHide.remove(DataComponentTypes.ITEM_MODEL);
            this.commonComponentsToHide.remove(DataComponentTypes.CUSTOM_NAME);
            this.commonComponentsToHide.remove(DataComponentTypes.CUSTOM_MODEL_DATA);
            this.commonComponentsToHide.remove(DataComponentTypes.TOOLTIP_DISPLAY);
            this.commonComponentsToHide.remove(DataComponentTypes.TOOLTIP_STYLE);
        }
        this.eventAdapter = new PaperEventAdapter(this.textComponentAdapter);
        return true;
    }

    @Override
    @NotNull
    public PaperEventAdapter eventAdapter() {
        return this.eventAdapter;
    }

    @Override
    @NotNull
    public Listener createChatListener(@NotNull UniversalChatListenerCallback callback) {
        return new PaperChatListener(this, callback);
    }

    @Override
    @NotNull
    public Listener createDialogListener(@NotNull DialogClickHandler handler) {
        return new PaperDialogListener(handler);
    }

    @Override
    public void disallowLogin(@NotNull AsyncPlayerPreLoginEvent event, // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull AsyncPlayerPreLoginEvent.Result result, @NotNull NightComponent message) {
        event.disallow(result, this.textComponentAdapter.adaptComponent(message));
    }

    @Override
    public void closeDialog(@NotNull Player player) {
        player.closeDialog();
    }

    @Override
    public void showDialog(@NotNull Player player, @NotNull WrappedDialog dialog) {
        player.showDialog((DialogLike)this.dialogAdapter.adaptDialog(dialog));
    }

    @Override
    public int nextEntityId() {
        return Bukkit.getUnsafe().nextEntityId();
    }

    @NotNull
    public DialogAdapter<?> getDialogAdapter() {
        return this.dialogAdapter;
    }

    @NotNull
    public PaperTextComponentAdapter getTextComponentAdapter() {
        return this.textComponentAdapter;
    }

    @Override
    @NotNull
    public SimpleCommandMap getCommandMap() {
        return (SimpleCommandMap)Bukkit.getCommandMap();
    }

    @Override
    @NotNull
    public Map<String, Command> getKnownCommands(@NotNull SimpleCommandMap commandMap) {
        return commandMap.getKnownCommands();
    }

    @NotNull
    private Component adaptComponent(@NotNull NightComponent component) {
        return this.textComponentAdapter.adaptComponent(component);
    }

    @NotNull
    public static String serializeComponent(@NotNull Component component) {
        return (String)MiniMessage.miniMessage().serialize(component);
    }

    @Override
    @NotNull
    public NightProfile createProfile(@NotNull UUID uuid) {
        return new PaperProfile(Bukkit.createProfile((UUID)uuid));
    }

    @Override
    @NotNull
    public NightProfile createProfile(@NotNull String name) {
        return new PaperProfile(Bukkit.createProfile((String)name));
    }

    @Override
    @NotNull
    public NightProfile createProfile(@Nullable UUID uuid, @Nullable String name) {
        return new PaperProfile(Bukkit.createProfile((UUID)uuid, (String)name));
    }

    @Override
    @NotNull
    public NightProfile getProfile(@NotNull OfflinePlayer player) {
        return new PaperProfile(player.getPlayerProfile());
    }

    @Override
    public void sendTitles(@NotNull Player player, @NotNull NightComponent title, @NotNull NightComponent subtitle, int fadeIn, int stay, int fadeOut) {
        Component titleComp = this.adaptComponent(title);
        Component subComp = this.adaptComponent(subtitle);
        Title.Times times = Title.Times.times((Duration)Ticks.duration((long)fadeIn), (Duration)Ticks.duration((long)stay), (Duration)Ticks.duration((long)fadeOut));
        Title titles = Title.title((Component)titleComp, (Component)subComp, (Title.Times)times);
        player.showTitle(titles);
    }

    @Override
    @NotNull
    public InventoryView createView(@NotNull MenuType menuType, @NotNull NightComponent title, @NotNull Player player) {
        if (Version.isAtLeast(Version.MC_1_21_4)) {
            return menuType.typed().builder().title(this.adaptComponent(title)).build((HumanEntity)player);
        }
        return menuType.typed().create((HumanEntity)player, this.adaptComponent(title));
    }

    @Override
    @NotNull
    public String getTranslationKey(@NotNull Material material) {
        return PaperBridge.getTranslation((Translatable)material);
    }

    @Override
    @NotNull
    public String getTranslationKey(@NotNull Attribute attribute) {
        return PaperBridge.getTranslation((Translatable)attribute);
    }

    @Override
    @NotNull
    public String getTranslationKey(@NotNull EntityType entityType) {
        return PaperBridge.getTranslation((Translatable)entityType);
    }

    @Override
    @NotNull
    public String getTranslationKey(@NotNull Enchantment enchantment) {
        return PaperBridge.getTranslation((Translatable)enchantment);
    }

    @Override
    @NotNull
    public String getTranslationKey(@NotNull PotionEffectType effectType) {
        return PaperBridge.getTranslation((Translatable)effectType);
    }

    @NotNull
    public static String getTranslation(@NotNull Translatable translatable) {
        return translatable.translationKey();
    }

    @Override
    @NotNull
    public String getDisplayNameSerialized(@NotNull Player player) {
        return PaperBridge.serializeComponent(player.displayName());
    }

    @Override
    public void setDisplayName(@NotNull Player player, @NotNull NightComponent component) {
        player.displayName(this.adaptComponent(component));
    }

    @Override
    @Nullable
    public String getPlayerListHeaderSerialized(@NotNull Player player) {
        Component header = player.playerListHeader();
        return header == null ? null : PaperBridge.serializeComponent(header);
    }

    @Override
    @Nullable
    public String getPlayerListFooterSerialized(@NotNull Player player) {
        Component footer = player.playerListFooter();
        return footer == null ? null : PaperBridge.serializeComponent(footer);
    }

    @Override
    public void setPlayerListHeaderFooter(@NotNull Player player, @Nullable NightComponent header, @Nullable NightComponent footer) {
        TextComponent paperHeader = header == null ? Component.empty() : this.adaptComponent(header);
        TextComponent paperFooter = footer == null ? Component.empty() : this.adaptComponent(footer);
        player.sendPlayerListHeaderAndFooter((Component)paperHeader, (Component)paperFooter);
    }

    @Override
    @NotNull
    public String getPlayerListNameSerialized(@NotNull Player player) {
        return PaperBridge.serializeComponent(player.playerListName());
    }

    @Override
    public void setPlayerListName(@NotNull Player player, @NotNull NightComponent name) {
        player.playerListName(this.adaptComponent(name));
    }

    @Override
    public void kick(@NotNull Player player, @Nullable NightComponent component) {
        player.kick(component == null ? null : this.adaptComponent(component));
    }

    @Override
    public void setCustomName(@NotNull Entity entity, @NotNull NightComponent component) {
        entity.customName(this.adaptComponent(component));
    }

    @Override
    @Nullable
    public String getEntityName(@NotNull Entity entity) {
        Component component = entity.customName();
        return component == null ? null : PaperBridge.serializeComponent(component);
    }

    @Override
    @NotNull
    public ItemStack setType(@NotNull ItemStack itemStack, @NotNull Material material) {
        return itemStack.withType(material);
    }

    @Override
    public void editMeta(@NotNull ItemStack itemStack, @NotNull Consumer<ItemMeta> consumer) {
        itemStack.editMeta(consumer);
    }

    @Override
    public <T extends ItemMeta> void editMeta(@NotNull ItemStack itemStack, @NotNull Class<T> clazz, @NotNull Consumer<T> consumer) {
        itemStack.editMeta(clazz, consumer);
    }

    @Override
    @Nullable
    public String getCustomName(@NotNull ItemMeta meta) {
        Component component = Version.isBehind(Version.MC_1_21_5) ? meta.displayName() : meta.customName();
        return component == null ? null : PaperBridge.serializeComponent(component);
    }

    @Override
    public void setCustomName(@NotNull ItemMeta meta, @Nullable NightComponent name) {
        if (Version.isBehind(Version.MC_1_21_5)) {
            meta.displayName(name == null ? null : this.adaptComponent(name));
        } else {
            meta.customName(name == null ? null : this.adaptComponent(name));
        }
    }

    @Override
    @Nullable
    public String getItemName(@NotNull ItemMeta meta) {
        return meta.hasItemName() ? PaperBridge.serializeComponent(meta.itemName()) : null;
    }

    @Override
    public void setItemName(@NotNull ItemMeta meta, @NotNull NightComponent name) {
        meta.itemName(this.adaptComponent(name));
    }

    @Override
    @Nullable
    public List<String> getLore(@NotNull ItemMeta meta) {
        List lore = meta.lore();
        return lore == null ? null : Lists.modify(lore, PaperBridge::serializeComponent);
    }

    @Override
    public void setLore(@NotNull ItemMeta meta, @Nullable List<NightComponent> lore) {
        meta.lore(lore == null ? null : Lists.modify(lore, this::adaptComponent));
    }

    @Override
    @Nullable
    public NightProfile getOwnerProfile(@NotNull ItemStack itemStack) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (!(itemMeta instanceof SkullMeta)) {
            return null;
        }
        SkullMeta skullMeta = (SkullMeta)itemMeta;
        PlayerProfile profile = skullMeta.getPlayerProfile();
        return profile == null ? null : new PaperProfile(profile);
    }

    @Override
    @NotNull
    public Set<String> getCommonComponentsToHide() {
        if (this.commonComponentsToHide == null) {
            return new HashSet<String>();
        }
        return this.commonComponentsToHide.stream().map(BukkitThing::getAsString).collect(Collectors.toSet());
    }

    @Override
    @NotNull
    public Set<String> getHiddenComponents(@NotNull ItemStack itemStack) {
        TooltipDisplay tooltipDisplay = (TooltipDisplay)itemStack.getData(DataComponentTypes.TOOLTIP_DISPLAY);
        if (tooltipDisplay == null) {
            return Collections.emptySet();
        }
        return tooltipDisplay.hiddenComponents().stream().map(BukkitThing::getAsString).collect(Collectors.toSet());
    }

    @Override
    public void hideComponents(@NotNull ItemStack itemStack) {
        if (this.commonComponentsToHide == null) {
            return;
        }
        PaperBridge.hidePaperComponents(itemStack, this.commonComponentsToHide);
    }

    @Override
    public void hideComponents(@NotNull ItemStack itemStack, @NotNull Set<String> componentNames) {
        Set<DataComponentType> componentTypes = componentNames.stream().map(name -> BukkitThing.getByString(RegistryType.Paper.DATA_COMPONENT_TYPE, name)).filter(Objects::nonNull).collect(Collectors.toSet());
        PaperBridge.hidePaperComponents(itemStack, componentTypes);
    }

    public static void hidePaperComponents(@NotNull ItemStack itemStack, @NotNull Set<DataComponentType> componentTypes) {
        try {
            TooltipDisplay tooltipDisplay = (TooltipDisplay)TooltipDisplay.tooltipDisplay().hiddenComponents(componentTypes).build();
            itemStack.setData(DataComponentTypes.TOOLTIP_DISPLAY, (Object)tooltipDisplay);
        }
        catch (NoSuchElementException exception) {
            exception.printStackTrace();
        }
    }

    @Override
    @NotNull
    public PaperBossBar createBossBar(@NotNull NightComponent title, @NotNull NightBarColor barColor, @NotNull NightBarOverlay barOverlay, NightBarFlag ... barFlags) {
        Component name = this.textComponentAdapter.adaptComponent(title);
        BossBar.Color color = PaperBossBarAdapter.adaptColor(barColor);
        BossBar.Overlay overlay = PaperBossBarAdapter.adaptOverlay(barOverlay);
        BossBar bar = BossBar.bossBar((Component)name, (float)0.0f, (BossBar.Color)color, (BossBar.Overlay)overlay);
        return new PaperBossBar(this, bar).addFlags(barFlags);
    }
}

