/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.nightcore.util;

import org.jetbrains.annotations.NotNull;

public class LegacyColors {
    private static final char COLOR_CHAR = '\u00a7';
    public static final char ALT_COLOR_CHAR = '&';
    private static final String ALL_CODES = "0123456789AaBbCcDdEeFfKkLlMmNnOoRrXx";

    @NotNull
    public static String plainColors(@NotNull String string) {
        string = LegacyColors.plainHEXColors(string);
        string = LegacyColors.plainDefaultColors(string);
        return string;
    }

    @NotNull
    public static String plainDefaultColors(@NotNull String string) {
        char[] b = string.toCharArray();
        for (int i = 0; i < b.length - 1; ++i) {
            if (b[i] != '\u00a7' || ALL_CODES.indexOf(b[i + 1]) <= -1) continue;
            b[i] = 38;
            b[i + 1] = Character.toLowerCase(b[i + 1]);
        }
        return new String(b);
    }

    @NotNull
    public static String plainHEXColors(@NotNull String str) {
        int index;
        StringBuilder builder = new StringBuilder(str);
        while ((index = builder.toString().indexOf("\u00a7x")) >= 0) {
            int count = 0;
            builder.replace(index, index + 2, "#");
            int point = index + 1;
            while (count < 6) {
                builder.deleteCharAt(point);
                ++count;
                ++point;
            }
        }
        return builder.toString();
    }
}

