/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.nightcore.util;

import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.util.Numbers;

public class ArrayUtil {
    private static final String ARRAY_DELIMITER = ",";

    @NotNull
    public static String arrayToString(double[] array) {
        return ArrayUtil.arrayToString(DoubleStream.of(array).boxed());
    }

    @NotNull
    public static String arrayToString(int[] array) {
        return ArrayUtil.arrayToString(IntStream.of(array).boxed());
    }

    @NotNull
    public static String arrayToString(long[] array) {
        return ArrayUtil.arrayToString(LongStream.of(array).boxed());
    }

    @NotNull
    public static String arrayToString(String[] array) {
        return ArrayUtil.arrayToString(Stream.of(array));
    }

    public static String[] parseStringArray(@NotNull String string) {
        return string.split(Pattern.quote(ARRAY_DELIMITER));
    }

    public static int[] parseIntArray(@NotNull String string) {
        return Stream.of(ArrayUtil.arrayFromString(string, Integer[]::new, raw -> Numbers.parseInteger(raw).orElseThrow())).mapToInt(i -> i).toArray();
    }

    public static double[] parseDoubleArray(@NotNull String string) {
        return Stream.of(ArrayUtil.arrayFromString(string, Double[]::new, raw -> Numbers.parseDouble(raw).orElseThrow())).mapToDouble(d -> d).toArray();
    }

    public static long[] parseLongArray(@NotNull String string) {
        return Stream.of(ArrayUtil.arrayFromString(string, Long[]::new, raw -> Numbers.parseLong(raw).orElseThrow())).mapToLong(i -> i).toArray();
    }

    @NotNull
    private static <T> String arrayToString(@NotNull Stream<T> stream) {
        return stream.map(String::valueOf).collect(Collectors.joining(ARRAY_DELIMITER));
    }

    private static <T> T[] arrayFromString(@NotNull String string, @NotNull Function<Integer, T[]> creator, @NotNull Function<String, T> converter) {
        String[] split = string.split(Pattern.quote(ARRAY_DELIMITER));
        ArrayList<T> parsed = new ArrayList<T>();
        for (String raw : split) {
            try {
                parsed.add(converter.apply(raw.trim()));
            }
            catch (NumberFormatException | NoSuchElementException runtimeException) {
                // empty catch block
            }
        }
        return parsed.toArray(creator.apply(0));
    }
}

