/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.nightcore.locale;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.NightPlugin;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.locale.LangContainer;
import su.nightexpress.nightcore.locale.LangElement;
import su.nightexpress.nightcore.locale.entry.MessageLocale;
import su.nightexpress.nightcore.locale.message.MessageData;
import su.nightexpress.nightcore.manager.SimpleManager;
import su.nightexpress.nightcore.util.FileUtil;
import su.nightexpress.nightcore.util.Reflex;
import su.nightexpress.nightcore.util.text.night.ParserUtils;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;

public class LangRegistry
extends SimpleManager<NightPlugin> {
    public static final String DEFAULT_LANGUAGE = "en";
    public static final String DIRECTORY = "/lang/";
    private final List<LangElement> elements = new ArrayList<LangElement>();
    private FileConfig config;

    public LangRegistry(@NotNull NightPlugin plugin) {
        super(plugin);
    }

    @Override
    protected void onLoad() {
    }

    @Override
    protected void onShutdown() {
        this.elements.clear();
    }

    public void complete() {
        if (this.config != null) {
            this.config.saveChanges();
            this.config = null;
        }
    }

    @NotNull
    public static List<LangElement> getElements(@NotNull Class<?> source) {
        return Reflex.getStaticFields(source, LangElement.class, false);
    }

    public static void loadEntries(@NotNull Class<?> source, @NotNull NightPlugin plugin, @NotNull FileConfig config) {
        LangRegistry.loadEntries(LangRegistry.getElements(source), plugin, config);
    }

    public static void loadEntries(@NotNull Collection<LangElement> elements, @NotNull NightPlugin plugin, @NotNull FileConfig config) {
        elements.forEach(element -> element.load(plugin, config));
    }

    public boolean hasElements() {
        return !this.elements.isEmpty();
    }

    public void register(@NotNull Class<? extends LangContainer> clazz) {
        this.elements.addAll(LangRegistry.getElements(clazz));
    }

    public void inject(@NotNull LangContainer langContainer) {
        this.inject(langContainer.getClass());
    }

    public void inject(@NotNull Class<? extends LangContainer> langClass) {
        if (this.config != null) {
            LangRegistry.loadEntries(langClass, (NightPlugin)this.plugin, this.config);
        } else {
            ((NightPlugin)this.plugin).warn("Lang Container " + langClass.getSimpleName() + " is not injected due to be out of the #enable() phase.");
        }
    }

    public void loadLocale() {
        if (this.elements.isEmpty()) {
            return;
        }
        ((NightPlugin)this.plugin).extractResources(DIRECTORY);
        this.updateLegacy();
        String userLocale = ((NightPlugin)this.plugin).getDetails().getLanguage();
        File file = new File(String.valueOf(((NightPlugin)this.plugin).getDataFolder()) + DIRECTORY, this.getFileName(userLocale));
        boolean isSupportedLocale = file.exists();
        String langCode = isSupportedLocale ? userLocale : DEFAULT_LANGUAGE;
        this.config = FileConfig.loadOrExtract(this.plugin, DIRECTORY, this.getFileName(langCode));
        if (!isSupportedLocale) {
            ((NightPlugin)this.plugin).warn("Lang file for the '" + userLocale + "' locale does not exist. Will use the '" + langCode + "' one.");
        }
        LangRegistry.loadEntries(this.elements, (NightPlugin)this.plugin, this.config);
    }

    private void updateLegacy() {
        FileUtil.getConfigFiles(String.valueOf(((NightPlugin)this.plugin).getDataFolder()) + DIRECTORY).forEach(messagesFile -> {
            String messagesName = messagesFile.getName();
            if (!messagesName.startsWith("messages_")) {
                return;
            }
            String langCode = messagesName.substring("messages_".length(), messagesName.length() - 4);
            String dirPath = String.valueOf(((NightPlugin)this.plugin).getDataFolder()) + DIRECTORY;
            File langFile = new File(dirPath, this.getFileName(langCode));
            if (langFile.exists()) {
                return;
            }
            Path originPath = Paths.get(messagesFile.getPath(), new String[0]);
            Path backupPath = Paths.get(messagesFile.getPath() + ".backup", new String[0]);
            Path renewPath = Paths.get(dirPath + this.getFileName(langCode), new String[0]);
            try {
                Files.copy(originPath, backupPath, new CopyOption[0]);
                FileConfig messagesConfig = new FileConfig((File)messagesFile);
                this.elements.forEach(element -> {
                    String inline;
                    if (!(element instanceof MessageLocale)) {
                        return;
                    }
                    MessageLocale messageLocale = (MessageLocale)element;
                    ArrayList<String> text = new ArrayList<String>(messagesConfig.getStringList(messageLocale.getPath()));
                    if (text.isEmpty()) {
                        text.add(messagesConfig.getString(messageLocale.getPath(), ""));
                    }
                    if (!MessageData.hasLegacyData(inline = String.join((CharSequence)TagWrappers.BR, text))) {
                        return;
                    }
                    MessageData.Builder builder = MessageData.builder();
                    String message = MessageData.extractAndParseOld(inline, builder);
                    MessageData data = builder.build();
                    String[] textLines = ParserUtils.breakDownLineSplitters(data.serialize() + message);
                    if (textLines.length == 1) {
                        messagesConfig.set(messageLocale.getPath(), textLines[0]);
                    } else {
                        messagesConfig.set(messageLocale.getPath(), Arrays.asList(textLines));
                    }
                });
                messagesConfig.saveChanges();
                Files.move(originPath, renewPath, new CopyOption[0]);
            }
            catch (IOException exception) {
                exception.printStackTrace();
            }
        });
    }

    @NotNull
    public String getFileName(@NotNull String langCode) {
        return FileConfig.withExtension("lang_" + langCode);
    }
}

