/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.nightcore.db.query.data;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.db.query.TypedValue;
import su.nightexpress.nightcore.db.sql.column.Column;

public class Values<T> {
    private final List<TypedValue<T>> values = new ArrayList<TypedValue<T>>();
    private final Function<Column, String> columnMapper;

    Values(@NotNull Function<Column, String> columnMapper) {
        this.columnMapper = columnMapper;
    }

    @NotNull
    public static <T> Values<T> forInsert() {
        return new Values<T>(Column::getNameEscaped);
    }

    @NotNull
    public static <T> Values<T> forUpdate() {
        return new Values<T>(column -> column.getNameEscaped() + " = ?");
    }

    @NotNull
    public String toSQL() {
        return this.values.stream().map(TypedValue::toSQL).collect(Collectors.joining(","));
    }

    public int count() {
        return this.values.size();
    }

    @NotNull
    public String getValue(@NotNull T entity, int index) {
        return this.values.get(index).extract(entity);
    }

    @NotNull
    public Values<T> setValue(@NotNull Column column, @NotNull Function<T, String> function) {
        this.values.add(new TypedValue<T>(this.columnMapper.apply(column), function));
        return this;
    }
}

