/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.nightcore.configuration;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.attribute.Attribute;
import org.bukkit.configuration.MemorySection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.MenuType;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.bridge.wrap.NightSound;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.configuration.ConfigType;
import su.nightexpress.nightcore.util.BukkitThing;
import su.nightexpress.nightcore.util.Enums;
import su.nightexpress.nightcore.util.LowerCase;
import su.nightexpress.nightcore.util.bukkit.NightItem;

public class ConfigTypes {
    public static final ConfigType<Boolean> BOOLEAN = ConfigType.of(MemorySection::getBoolean, FileConfig::set);
    public static final ConfigType<Integer> INT = ConfigType.of(MemorySection::getInt, FileConfig::set);
    public static final ConfigType<int[]> INT_ARRAY = ConfigType.of(FileConfig::getIntArray, FileConfig::setArray);
    public static final ConfigType<Double> DOUBLE = ConfigType.of(MemorySection::getDouble, FileConfig::set);
    public static final ConfigType<double[]> DOUBLE_ARRAY = ConfigType.of(FileConfig::getDoubleArray, FileConfig::setArray);
    public static final ConfigType<Long> LONG = ConfigType.of(MemorySection::getLong, FileConfig::set);
    public static final ConfigType<long[]> LONG_ARRAY = ConfigType.of(FileConfig::getLongArray, FileConfig::setArray);
    public static final ConfigType<String> STRING = ConfigType.of(FileConfig::getString, FileConfig::set);
    public static final ConfigType<String[]> STRING_ARRAY = ConfigType.of(FileConfig::getStringArray, FileConfig::setStringArray);
    public static final ConfigType<List<String>> STRING_LIST = ConfigType.of(MemorySection::getStringList, FileConfig::set);
    public static final ConfigType<Set<String>> STRING_SET = ConfigType.of(FileConfig::getStringSet, FileConfig::set);
    public static final ConfigType<List<String>> STRING_LIST_LOWER_CASE = ConfigTypes.forList(LowerCase.INTERNAL::apply, key -> key);
    public static final ConfigType<Set<String>> STRING_SET_LOWER_CASE = ConfigTypes.forSet(LowerCase.INTERNAL::apply, key -> key);
    public static final ConfigType<NightItem> NIGHT_ITEM = ConfigType.of(FileConfig::getCosmeticItem, FileConfig::set);
    public static final ConfigType<NightSound> NIGHT_SOUND = ConfigType.of(FileConfig::readSound, FileConfig::set);
    public static final ConfigType<MenuType> MENU_TYPE = ConfigTypes.forNamespaced(BukkitThing::getMenuType);
    public static final ConfigType<EntityType> ENTITY_TYPE = ConfigTypes.forNamespaced(BukkitThing::getEntityType);
    public static final ConfigType<Set<EntityType>> ENTITY_TYPE_SET = ConfigTypes.forNamespacedSet(BukkitThing::getEntityType);
    public static final ConfigType<PotionEffectType> EFFECT_TYPE = ConfigTypes.forNamespaced(BukkitThing::getEffectType);
    public static final ConfigType<Material> MATERIAL = ConfigTypes.forNamespaced(BukkitThing::getMaterial);
    public static final ConfigType<Set<Material>> MATERIAL_SET = ConfigTypes.forNamespacedSet(BukkitThing::getMaterial);
    public static final ConfigType<Enchantment> ENCHANTMENT = ConfigTypes.forNamespaced(BukkitThing::getEnchantment);
    public static final ConfigType<Particle> PARTICLE = ConfigTypes.forNamespaced(BukkitThing::getParticle);
    public static final ConfigType<Sound> SOUND = ConfigTypes.forNamespaced(BukkitThing::getSound);
    public static final ConfigType<Attribute> ATTRIBUTE = ConfigTypes.forNamespaced(BukkitThing::getAttribute);

    @NotNull
    public static <E extends Enum<E>> ConfigType<E> forEnum(@NotNull Class<E> type) {
        ConfigType.Loader<Enum> reader = (config, path) -> config.getEnum(path, type);
        ConfigType.Writer<Enum> writer = (config, path, value) -> config.set(path, value.name());
        return ConfigType.of(reader, writer);
    }

    @NotNull
    public static <T extends Keyed> ConfigType<T> forNamespaced(@NotNull Function<String, T> fromString) {
        return ConfigType.of((config, path) -> Optional.ofNullable(config.getString(path)).map(fromString).orElse(null), (config, path, value) -> config.set(path, BukkitThing.getAsString(value)));
    }

    @NotNull
    public static <V> ConfigType<Set<V>> forSet(@NotNull Function<String, V> fromString, @NotNull Function<V, String> toString) {
        return ConfigType.of((config, path) -> config.getStringSet(path).stream().map(fromString).filter(Objects::nonNull).collect(Collectors.toCollection(HashSet::new)), (config, path, set) -> config.set(path, set.stream().map(toString).toList()));
    }

    @NotNull
    public static <V> ConfigType<List<V>> forList(@NotNull Function<String, V> fromString, @NotNull Function<V, String> toString) {
        return ConfigType.of((config, path) -> config.getStringList(path).stream().map(fromString).filter(Objects::nonNull).collect(Collectors.toCollection(ArrayList::new)), (config, path, set) -> config.set(path, set.stream().map(toString).toList()));
    }

    @NotNull
    public static <V extends Keyed> ConfigType<Set<V>> forNamespacedSet(@NotNull Function<String, V> fromString) {
        return ConfigTypes.forSet(fromString, BukkitThing::getAsString);
    }

    @NotNull
    public static <V extends Enum<V>> ConfigType<EnumSet<V>> forEnumSet(@NotNull Class<V> type) {
        return ConfigType.of((config, path) -> config.getStringSet(path).stream().map(string -> Enums.get(string, type)).filter(Objects::nonNull).collect(Collectors.toCollection(() -> EnumSet.noneOf(type))), (config, path, set) -> config.set(path, set.stream().map(Enum::name).toList()));
    }

    @NotNull
    public static <V> ConfigType<Map<String, V>> forMap(@NotNull ConfigType<V> type) {
        return ConfigTypes.forMap(s -> s, s -> s, type);
    }

    @NotNull
    public static <V> ConfigType<Map<String, V>> forMapWithLowerKeys(@NotNull ConfigType<V> type) {
        return ConfigTypes.forMap(LowerCase.INTERNAL::apply, key -> key, type);
    }

    @NotNull
    public static <K, V> ConfigType<Map<K, V>> forMap(@NotNull Function<String, K> strToKey, @NotNull Function<K, String> keyToStr, @NotNull ConfigType<V> valType) {
        return ConfigType.of((config, path) -> {
            LinkedHashMap map = new LinkedHashMap();
            config.getSection(path).forEach(key -> {
                Object k = strToKey.apply((String)key);
                if (k == null) {
                    return;
                }
                valType.read(config, path + "." + key).ifPresent(value -> map.put(k, value));
            });
            return map;
        }, (config, path, map) -> {
            config.set(path, null);
            map.forEach((key, value) -> valType.write(config, path + "." + (String)keyToStr.apply(key), value));
        });
    }
}

