/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.nightcore.configuration;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.configuration.ConfigProperty;
import su.nightexpress.nightcore.configuration.ConfigType;

public class AbstractConfig {
    protected final List<ConfigProperty<?>> properties = new ArrayList();

    @NotNull
    protected final <T> ConfigProperty<T> addProperty(@NotNull ConfigType<T> type, @NotNull String path, @NotNull T defaultValue, String ... description) {
        return this.addProperty(ConfigProperty.of(type, path, defaultValue, description));
    }

    @NotNull
    protected final <T> ConfigProperty<T> addProperty(@NotNull ConfigProperty<T> property) {
        this.properties.add(property);
        return property;
    }

    public void load(@NotNull FileConfig config) {
        this.properties.forEach(configProperty -> configProperty.loadOrWriteDefault(config));
    }
}

