/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.nightcore.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.bukkit.Color;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.nightcore.NightCorePlugin;
import su.nightexpress.nightcore.bridge.wrap.NightSound;
import su.nightexpress.nightcore.config.ConfigValue;
import su.nightexpress.nightcore.config.Writeable;
import su.nightexpress.nightcore.configuration.ConfigProperty;
import su.nightexpress.nightcore.configuration.ConfigType;
import su.nightexpress.nightcore.util.ArrayUtil;
import su.nightexpress.nightcore.util.BukkitThing;
import su.nightexpress.nightcore.util.Enums;
import su.nightexpress.nightcore.util.FileUtil;
import su.nightexpress.nightcore.util.ItemNbt;
import su.nightexpress.nightcore.util.ItemUtil;
import su.nightexpress.nightcore.util.LegacyColors;
import su.nightexpress.nightcore.util.LocationUtil;
import su.nightexpress.nightcore.util.Reflex;
import su.nightexpress.nightcore.util.StringUtil;
import su.nightexpress.nightcore.util.bukkit.NightItem;
import su.nightexpress.nightcore.util.sound.AbstractSound;
import su.nightexpress.nightcore.util.text.night.NightMessage;

public class FileConfig
extends YamlConfiguration {
    public static final String EXTENSION = ".yml";
    private final Path path;
    private boolean changed;

    @Deprecated
    public FileConfig(@NotNull String path, @NotNull String file) {
        this(new File(path, file));
    }

    @Deprecated
    public FileConfig(@NotNull File file) {
        this.changed = false;
        this.options().width(512);
        FileUtil.create(file);
        this.path = file.toPath();
        this.reload();
    }

    private FileConfig(@NotNull Path path) {
        this.path = path;
        this.changed = false;
        this.options().width(512);
    }

    @NotNull
    public static FileConfig load(@NotNull String path, @NotNull String file) {
        return FileConfig.load(Path.of(path, file));
    }

    @NotNull
    public static FileConfig load(@NotNull Path path) {
        FileConfig config = new FileConfig(path);
        config.load();
        return config;
    }

    public static boolean isConfig(@NotNull File file) {
        return file.getName().endsWith(EXTENSION);
    }

    @NotNull
    public static String withExtension(@NotNull String fileName) {
        return fileName + EXTENSION;
    }

    @NotNull
    public static String getName(@NotNull File file) {
        String name = file.getName();
        if (FileConfig.isConfig(file)) {
            return name.substring(0, name.length() - EXTENSION.length());
        }
        return name;
    }

    @Deprecated
    @NotNull
    public static FileConfig loadOrExtract(@NotNull NightCorePlugin plugin, @NotNull String path, @NotNull String file) {
        if (!((String)path).endsWith("/")) {
            path = (String)path + "/";
        }
        return FileConfig.loadOrExtract(plugin, (String)path + file);
    }

    @Deprecated
    @NotNull
    public static FileConfig loadOrExtract(@NotNull NightCorePlugin plugin, @NotNull String filePath) {
        File file;
        if (!((String)filePath).startsWith("/")) {
            filePath = "/" + (String)filePath;
        }
        if (FileUtil.create(file = new File(String.valueOf(plugin.getDataFolder()) + (String)filePath))) {
            try (InputStream input = plugin.getClass().getResourceAsStream((String)filePath);){
                if (input != null) {
                    FileUtil.copy(input, file);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return new FileConfig(file);
    }

    @NotNull
    public static List<FileConfig> loadAll(@NotNull String path) {
        return FileConfig.loadAll(path, false);
    }

    @NotNull
    public static List<FileConfig> loadAll(@NotNull String path, boolean deep) {
        return FileUtil.getConfigFiles(path, deep).stream().map(FileConfig::new).toList();
    }

    public void initializeOptions(@NotNull Class<?> clazz) {
        FileConfig.initializeOptions(clazz, this);
    }

    public static void initializeOptions(@NotNull Class<?> clazz, @NotNull FileConfig config) {
        for (ConfigValue value : Reflex.getStaticFields(clazz, ConfigValue.class, false)) {
            value.read(config);
        }
    }

    @Deprecated
    @NotNull
    public File getFile() {
        return this.path.toFile();
    }

    @NotNull
    public Path getPath() {
        return this.path;
    }

    @Deprecated
    public boolean reload() {
        this.load();
        return true;
    }

    public void load() {
        FileUtil.createFileIfNotExists(this.path);
        this.changed = false;
        try (BufferedReader reader = Files.newBufferedReader(this.path, StandardCharsets.UTF_8);){
            this.load(reader);
        }
        catch (IOException | IllegalArgumentException | InvalidConfigurationException exception) {
            exception.printStackTrace();
        }
    }

    public void save() {
        FileUtil.createFileIfNotExists(this.path);
        try (BufferedWriter writer = Files.newBufferedWriter(this.path, StandardCharsets.UTF_8, new OpenOption[0]);){
            writer.write(this.saveToString());
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
    }

    public boolean saveChanges() {
        if (!this.changed) {
            return false;
        }
        this.save();
        this.changed = false;
        return true;
    }

    public void edit(@NotNull Consumer<FileConfig> consumer) {
        consumer.accept(this);
        this.saveChanges();
    }

    public boolean addMissing(@NotNull String path, @Nullable Object val) {
        if (this.contains(path)) {
            return false;
        }
        this.set(path, val);
        return true;
    }

    @NotNull
    public <T> T get(@NotNull ConfigProperty<T> property) {
        return property.read(this);
    }

    @NotNull
    public <T> T get(@NotNull ConfigType<T> type, @NotNull String path, @NotNull T def, String ... comments) {
        if (!this.contains(path)) {
            type.write(this, path, def);
            this.setComments(path, comments);
        }
        return type.read(this, path, def);
    }

    public void setArray(@NotNull String path, double[] array) {
        this.set(path, array == null ? null : ArrayUtil.arrayToString(array));
    }

    public void setArray(@NotNull String path, int[] array) {
        this.set(path, array == null ? null : ArrayUtil.arrayToString(array));
    }

    public void setArray(@NotNull String path, long[] array) {
        this.set(path, array == null ? null : ArrayUtil.arrayToString(array));
    }

    public void set(@NotNull String path, @Nullable Object value) {
        if (value instanceof Writeable) {
            Writeable writeable = (Writeable)((Object)value);
            writeable.write(this, path);
            this.changed = true;
            return;
        }
        if (value instanceof String) {
            String str = (String)((Object)value);
            value = LegacyColors.plainColors(str);
        } else if (value instanceof Collection) {
            Collection collection = value;
            ArrayList list = new ArrayList(collection);
            list.replaceAll(obj -> {
                Object object;
                if (obj instanceof String) {
                    String str = (String)obj;
                    object = LegacyColors.plainColors(str);
                } else {
                    object = obj;
                }
                return object;
            });
            value = list;
        } else if (value instanceof Location) {
            Location location = (Location)value;
            value = LocationUtil.serialize(location);
        } else if (value instanceof Enum) {
            Enum en = (Enum)((Object)value);
            value = en.name();
        }
        super.set(path, (Object)value);
        this.changed = true;
    }

    public void setComments(@NotNull String path, String ... comments) {
        this.setComments(path, comments == null ? null : Arrays.asList(comments));
    }

    public void setInlineComments(@NotNull String path, String ... comments) {
        this.setInlineComments(path, comments == null ? null : Arrays.asList(comments));
    }

    public void setComments(@NotNull String path, @Nullable List<String> comments) {
        if (!this.areCommentsDifferent(this.getComments(path), comments)) {
            return;
        }
        super.setComments(path, comments);
        this.changed = true;
    }

    public void setInlineComments(@NotNull String path, @Nullable List<String> comments) {
        if (!this.areCommentsDifferent(this.getInlineComments(path), comments)) {
            return;
        }
        super.setInlineComments(path, comments);
        this.changed = true;
    }

    private boolean areCommentsDifferent(@NotNull List<String> current, @Nullable List<String> comments) {
        if (comments == null || comments.isEmpty()) {
            return !current.isEmpty();
        }
        return !new HashSet<String>(current).equals(new HashSet<String>(comments));
    }

    public boolean remove(@NotNull String path) {
        if (!this.contains(path)) {
            return false;
        }
        this.set(path, null);
        return true;
    }

    @NotNull
    public Set<String> getSection(@NotNull String path) {
        ConfigurationSection section = this.getConfigurationSection(path);
        return section == null ? Collections.emptySet() : section.getKeys(false);
    }

    @Nullable
    public String getString(@NotNull String path) {
        String str = super.getString(path);
        return str == null || str.isEmpty() ? null : str;
    }

    @NotNull
    public String getString(@NotNull String path, @Nullable String def) {
        String str = super.getString(path, def);
        return str == null ? "" : str;
    }

    @NotNull
    public Set<String> getStringSet(@NotNull String path) {
        return new HashSet<String>(this.getStringList(path));
    }

    @Deprecated
    @Nullable
    public Location getLocation(@NotNull String path) {
        String raw = this.getString(path);
        return raw == null ? null : LocationUtil.deserialize(raw);
    }

    @Deprecated
    public void setIntArray(@NotNull String path, int[] arr) {
        this.setArray(path, arr);
    }

    public int[] getIntArray(@NotNull String path) {
        return this.getIntArray(path, new int[0]);
    }

    public int[] getIntArray(@NotNull String path, int[] defaultArray) {
        String str = this.getString(path);
        return str == null ? defaultArray : ArrayUtil.parseIntArray(str);
    }

    public double[] getDoubleArray(@NotNull String path) {
        return this.getDoubleArray(path, new double[0]);
    }

    public double[] getDoubleArray(@NotNull String path, double[] defaultArray) {
        String str = this.getString(path);
        return str == null ? defaultArray : ArrayUtil.parseDoubleArray(str);
    }

    public long[] getLongArray(@NotNull String path) {
        return this.getLongArray(path, new long[0]);
    }

    public long[] getLongArray(@NotNull String path, long[] defaultArray) {
        String str = this.getString(path);
        return str == null ? defaultArray : ArrayUtil.parseLongArray(str);
    }

    @NotNull
    public String[] getStringArray(@NotNull String path) {
        return this.getStringArray(path, new String[0]);
    }

    @NotNull
    public String[] getStringArray(@NotNull String path, @NotNull String[] def) {
        String str = this.getString(path);
        return str == null ? def : str.split(",");
    }

    public void setStringArray(@NotNull String path, String[] arr) {
        this.set(path, arr == null ? null : String.join((CharSequence)",", arr));
    }

    @Nullable
    public <T extends Enum<T>> T getEnum(@NotNull String path, @NotNull Class<T> clazz) {
        return Enums.get(this.getString(path), clazz);
    }

    @NotNull
    public <T extends Enum<T>> T getEnum(@NotNull String path, @NotNull Class<T> clazz, @NotNull T def) {
        return (T)((Enum)Enums.parse(this.getString(path), clazz).orElse(def));
    }

    @NotNull
    public <T extends Enum<T>> List<T> getEnumList(@NotNull String path, @NotNull Class<T> clazz) {
        return this.getStringSet(path).stream().map(str -> Enums.parse(str, clazz).orElse(null)).filter(Objects::nonNull).toList();
    }

    @NotNull
    public NightItem getCosmeticItem(@NotNull String path, @NotNull NightItem def) {
        return this.contains(path) ? this.getCosmeticItem(path) : def;
    }

    @NotNull
    public NightItem getCosmeticItem(@NotNull String path) {
        return NightItem.read(this, path);
    }

    @Deprecated
    @NotNull
    public su.nightexpress.nightcore.util.bukkit.NightSound getSound(@NotNull String path) {
        return su.nightexpress.nightcore.util.bukkit.NightSound.read(this, path);
    }

    @Nullable
    public NightSound readSound(@NotNull String path) {
        return AbstractSound.read(this, path);
    }

    @Nullable
    public NightSound readSound(@NotNull String path, @NotNull NightSound def) {
        NightSound sound = this.readSound(path);
        return sound == null ? def : sound;
    }

    @Deprecated
    public void setSound(@NotNull String path, @NotNull su.nightexpress.nightcore.util.bukkit.NightSound sound) {
        this.set(path, sound);
    }

    @Deprecated
    @NotNull
    public ItemStack getItem(@NotNull String path, @Nullable ItemStack def) {
        ItemStack item = this.getItem(path);
        return item.getType().isAir() && def != null ? def : item;
    }

    @Deprecated
    @NotNull
    public ItemStack getItem(@NotNull String path) {
        String name;
        ItemMeta meta;
        String headSkin;
        Material material;
        if (!((String)path).isEmpty() && !((String)path).endsWith(".")) {
            path = (String)path + ".";
        }
        if ((material = BukkitThing.getMaterial(this.getString((String)path + "Material", BukkitThing.toString((Keyed)Material.AIR)))) == null || material.isAir()) {
            return new ItemStack(Material.AIR);
        }
        ItemStack item = new ItemStack(material);
        item.setAmount(this.getInt((String)path + "Amount", 1));
        String headTexture = this.getString((String)path + "Head_Texture");
        if (headTexture != null && !headTexture.isEmpty()) {
            try {
                byte[] decoded = Base64.getDecoder().decode(headTexture);
                String decodedStr = new String(decoded, StandardCharsets.UTF_8);
                JsonElement element = JsonParser.parseString((String)decodedStr);
                String url = element.getAsJsonObject().getAsJsonObject("textures").getAsJsonObject("SKIN").get("url").getAsString();
                url = url.substring("http://textures.minecraft.net/texture/".length());
                this.set((String)path + "SkinURL", url);
                this.remove((String)path + "Head_Texture");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if ((headSkin = this.getString((String)path + "SkinURL")) != null) {
            ItemUtil.setProfileBySkinURL(item, headSkin);
        }
        if ((meta = item.getItemMeta()) == null) {
            return item;
        }
        int durability = this.getInt((String)path + "Durability");
        if (durability > 0 && meta instanceof Damageable) {
            Damageable damageable = (Damageable)meta;
            damageable.setDamage(durability);
        }
        ItemUtil.setCustomName(meta, (name = this.getString((String)path + "Name")) == null ? null : NightMessage.parse(name));
        ItemUtil.setLore(meta, (List<String>)this.getStringList((String)path + "Lore"));
        for (String sKey : this.getSection((String)path + "Enchants")) {
            int level;
            Enchantment enchantment = BukkitThing.getEnchantment(sKey);
            if (enchantment == null || (level = this.getInt((String)path + "Enchants." + sKey)) <= 0) continue;
            meta.addEnchant(enchantment, level, true);
        }
        int model = this.getInt((String)path + "Custom_Model_Data");
        meta.setCustomModelData(model != 0 ? Integer.valueOf(model) : null);
        List flags = this.getStringList((String)path + "Item_Flags");
        if (flags.contains("*")) {
            meta.addItemFlags(ItemFlag.values());
        } else {
            flags.stream().map(str -> StringUtil.getEnum(str, ItemFlag.class).orElse(null)).filter(Objects::nonNull).forEach(xva$0 -> meta.addItemFlags(new ItemFlag[]{xva$0}));
        }
        String colorRaw = this.getString((String)path + "Color");
        if (colorRaw != null && !colorRaw.isEmpty()) {
            Color color = StringUtil.getColor(colorRaw);
            if (meta instanceof LeatherArmorMeta) {
                LeatherArmorMeta armorMeta = (LeatherArmorMeta)meta;
                armorMeta.setColor(color);
            } else if (meta instanceof PotionMeta) {
                PotionMeta potionMeta = (PotionMeta)meta;
                potionMeta.setColor(color);
            }
        }
        meta.setUnbreakable(this.getBoolean((String)path + "Unbreakable"));
        item.setItemMeta(meta);
        return item;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void setItem(@NotNull String path, @Nullable ItemStack item) {
        void var6_9;
        if (item == null) {
            this.set((String)path, null);
            return;
        }
        if (!((String)path).endsWith(".")) {
            path = (String)path + ".";
        }
        this.set(((String)path).substring(0, ((String)path).length() - 1), null);
        Material material = item.getType();
        this.set((String)path + "Material", material.name());
        this.set((String)path + "Amount", item.getAmount() <= 1 ? null : Integer.valueOf(item.getAmount()));
        this.set((String)path + "SkinURL", ItemUtil.getProfileSkinURL(item));
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return;
        }
        if (meta instanceof Damageable) {
            Damageable damageable = (Damageable)meta;
            this.set((String)path + "Durability", damageable.getDamage() <= 0 ? null : Integer.valueOf(damageable.getDamage()));
        }
        this.set((String)path + "Name", meta.getDisplayName().isEmpty() ? null : meta.getDisplayName());
        this.set((String)path + "Lore", meta.getLore());
        for (Map.Entry entry : meta.getEnchants().entrySet()) {
            this.set((String)path + "Enchants." + ((Enchantment)entry.getKey()).getKey().getKey(), entry.getValue());
        }
        this.set((String)path + "Custom_Model_Data", meta.hasCustomModelData() ? Integer.valueOf(meta.getCustomModelData()) : null);
        Color color = null;
        Object var6_7 = null;
        if (meta instanceof PotionMeta) {
            PotionMeta potionMeta = (PotionMeta)meta;
            color = potionMeta.getColor();
        } else if (meta instanceof LeatherArmorMeta) {
            LeatherArmorMeta armorMeta = (LeatherArmorMeta)meta;
            color = armorMeta.getColor();
        }
        if (color != null) {
            String string = color.getRed() + "," + color.getGreen() + "," + color.getBlue();
        }
        this.set((String)path + "Color", var6_9);
        ArrayList<String> itemFlags = new ArrayList<String>(meta.getItemFlags().stream().map(Enum::name).toList());
        this.set((String)path + "Item_Flags", itemFlags.isEmpty() ? null : itemFlags);
        this.set((String)path + "Unbreakable", meta.isUnbreakable() ? Boolean.valueOf(true) : null);
    }

    @Deprecated
    @Nullable
    public ItemStack getItemEncoded(@NotNull String path) {
        String compressed = this.getString(path);
        if (compressed == null) {
            return null;
        }
        return ItemNbt.decompress(compressed);
    }

    @Deprecated
    public void setItemEncoded(@NotNull String path, @Nullable ItemStack item) {
        this.set(path, item == null ? null : ItemNbt.compress(item));
    }

    @Deprecated
    @NotNull
    public ItemStack[] getItemsEncoded(@NotNull String path) {
        return ItemNbt.decompress(this.getStringList(path));
    }

    @Deprecated
    public void setItemsEncoded(@NotNull String path, @NotNull List<ItemStack> item) {
        this.set(path, ItemNbt.compress(item));
    }
}

