/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.nightcore.commands.tree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.nightcore.commands.CommandRequirement;
import su.nightexpress.nightcore.commands.NodeExecutor;
import su.nightexpress.nightcore.commands.NodeUtils;
import su.nightexpress.nightcore.commands.argument.ArgumentReader;
import su.nightexpress.nightcore.commands.context.CommandContext;
import su.nightexpress.nightcore.commands.context.CommandContextBuilder;
import su.nightexpress.nightcore.commands.context.Suggestions;
import su.nightexpress.nightcore.commands.exceptions.CommandSyntaxException;
import su.nightexpress.nightcore.commands.tree.CommandNode;
import su.nightexpress.nightcore.commands.tree.ExecutableNode;
import su.nightexpress.nightcore.commands.tree.FlagNode;

public class LiteralNode
extends ExecutableNode {
    private final Map<String, FlagNode> flags = new LinkedHashMap<String, FlagNode>();

    public LiteralNode(@NotNull String name, @NotNull String description, @Nullable String permission, @NotNull List<CommandRequirement> requirements, @Nullable NodeExecutor executor) {
        super(name, description, permission, requirements, executor);
    }

    @Override
    @NotNull
    public Collection<? extends CommandNode> getRelevantNodes(@NotNull ArgumentReader reader) {
        return this.getChildren();
    }

    public void setArguments(CommandNode ... arguments) {
        this.setArguments(Arrays.asList(arguments));
    }

    public void setArguments(@NotNull List<? extends CommandNode> arguments) {
        CommandNode parent = this;
        while (!arguments.isEmpty()) {
            CommandNode first = arguments.removeFirst();
            parent.getChildren().clear();
            parent.addChildren(first);
            parent = first;
            if (!(first instanceof FlagNode)) continue;
            FlagNode flagNode = (FlagNode)first;
            this.flags.put(first.getName(), flagNode);
        }
    }

    @Override
    public boolean run(@NotNull CommandContext context) {
        if (this.executor != null) {
            this.executor.run(context, context.getArguments());
            return true;
        }
        return false;
    }

    @Override
    public void parse(@NotNull ArgumentReader reader, @NotNull CommandContextBuilder contextBuilder) throws CommandSyntaxException {
        contextBuilder.withNode(this, reader.getCursor());
        contextBuilder.withExecutor(this);
    }

    @Override
    protected void provideSuggestions(@NotNull ArgumentReader reader, @NotNull CommandContext context, @NotNull Suggestions suggestions) {
        suggestions.setSuggestions(List.of(this.name));
    }

    @NotNull
    public List<CommandNode> getArguments() {
        return NodeUtils.getArguments(this);
    }

    @NotNull
    public List<FlagNode> getFlags() {
        return new ArrayList<FlagNode>(this.flags.values());
    }

    @Nullable
    public FlagNode getFlag(@NotNull String name) {
        return this.flags.get(name);
    }

    @Override
    public boolean hasRequiredArguments() {
        return this.getArguments().stream().anyMatch(CommandNode::isRequired);
    }

    @Override
    @NotNull
    public String getUsage() {
        StringBuilder builder = new StringBuilder().append(this.name);
        this.getArguments().forEach(node -> {
            builder.append(" ");
            builder.append(node.getUsage());
        });
        return builder.toString();
    }
}

