/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.nightcore.commands.tree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.nightcore.commands.CommandRequirement;
import su.nightexpress.nightcore.commands.Commands;
import su.nightexpress.nightcore.commands.NodeExecutor;
import su.nightexpress.nightcore.commands.NodeUtils;
import su.nightexpress.nightcore.commands.argument.ArgumentReader;
import su.nightexpress.nightcore.commands.builder.LiteralNodeBuilder;
import su.nightexpress.nightcore.commands.context.CommandContext;
import su.nightexpress.nightcore.commands.context.CommandContextBuilder;
import su.nightexpress.nightcore.commands.context.Suggestions;
import su.nightexpress.nightcore.commands.exceptions.CommandSyntaxException;
import su.nightexpress.nightcore.commands.tree.CommandNode;
import su.nightexpress.nightcore.commands.tree.ExecutableNode;
import su.nightexpress.nightcore.core.config.CoreLang;
import su.nightexpress.nightcore.util.LowerCase;

public class HubNode
extends ExecutableNode {
    private String localizedName;

    public HubNode(@NotNull String name, @NotNull String description, @Nullable String permission, @NotNull List<CommandRequirement> requirements, @Nullable NodeExecutor executor, @Nullable String localizedName, boolean useHelpCommand) {
        super(name, description, permission, requirements, executor);
        this.setLocalizedName(localizedName);
        if (useHelpCommand) {
            this.addBranch(((LiteralNodeBuilder)((LiteralNodeBuilder)Commands.literal("help").description(CoreLang.COMMAND_HELP_DESC)).executes((context, arguments) -> this.sendCommandList(context))).build());
        }
    }

    public void setLocalizedName(@Nullable String localizedName) {
        this.localizedName = localizedName;
    }

    @Override
    @NotNull
    public Collection<? extends CommandNode> getRelevantNodes(@NotNull ArgumentReader reader) {
        String arg;
        CommandNode literalNode;
        if (!this.children.isEmpty() && (literalNode = (CommandNode)this.children.get(LowerCase.USER_LOCALE.apply(arg = reader.getCursorArgument()))) != null) {
            return Collections.singleton(literalNode);
        }
        return Collections.emptyList();
    }

    public void addBranch(@NotNull ExecutableNode node) {
        this.addChildren(node);
    }

    @Override
    public boolean run(@NotNull CommandContext context) {
        if (this.executor != null) {
            this.executor.run(context, context.getArguments());
            return true;
        }
        this.sendCommandList(context);
        return true;
    }

    @Override
    public void parse(@NotNull ArgumentReader reader, @NotNull CommandContextBuilder contextBuilder) throws CommandSyntaxException {
        contextBuilder.withNode(this, reader.getCursor());
        contextBuilder.withExecutor(this);
    }

    @Override
    public void suggests(@NotNull ArgumentReader reader, @NotNull CommandContext context, @NotNull Suggestions suggestions) {
        suggestions.setSuggestions(new ArrayList<String>(this.children.keySet()));
    }

    @Override
    protected void provideSuggestions(@NotNull ArgumentReader reader, @NotNull CommandContext context, @NotNull Suggestions suggestions) {
    }

    @Override
    @NotNull
    public String getUsage() {
        return this.name;
    }

    @Override
    @NotNull
    public String getLocalizedName() {
        return this.localizedName != null ? this.localizedName : this.getName();
    }

    private boolean sendCommandList(@NotNull CommandContext context) {
        CommandSender sender = context.getSender();
        CoreLang.HELP_PAGE_GENERAL.message().send(sender, replacer -> replacer.replace("%name%", this.getLocalizedName()).replace("%entry%", list -> this.getChildren().stream().sorted(Comparator.comparing(CommandNode::getName)).forEach(children -> {
            if (!children.hasPermission(sender)) {
                return;
            }
            if (!(children instanceof ExecutableNode)) {
                return;
            }
            ExecutableNode executable = (ExecutableNode)children;
            list.add(CoreLang.HELP_PAGE_ENTRY.text().replace("%command%", (NodeUtils.formatLabel((ExecutableNode)this, context) + " " + executable.getUsage()).trim()).replace("%description%", executable.getDescription()));
        })));
        return true;
    }
}

