/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.nightcore.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.commands.context.CommandContext;
import su.nightexpress.nightcore.commands.context.CommandContextBuilder;
import su.nightexpress.nightcore.commands.tree.CommandNode;
import su.nightexpress.nightcore.commands.tree.ExecutableNode;

public class NodeUtils {
    @NotNull
    public static String formatLabel(@NotNull ExecutableNode node, @NotNull CommandContext context) {
        return NodeUtils.formatLabel(node, context.getNodesPriorTo(node));
    }

    @NotNull
    public static String formatLabel(@NotNull ExecutableNode node, @NotNull CommandContextBuilder context) {
        return NodeUtils.formatLabel(node, context.getNodesPriorTo(node));
    }

    @NotNull
    private static String formatLabel(@NotNull ExecutableNode node, @NotNull List<CommandNode> priors) {
        String parent = priors.stream().map(CommandNode::getName).collect(Collectors.joining(" "));
        String current = node.getUsage();
        return (parent + " " + current).trim();
    }

    @NotNull
    public static List<CommandNode> getArguments(@NotNull CommandNode source) {
        ArrayList<CommandNode> args = new ArrayList<CommandNode>();
        CommandNode parent = source;
        while (parent.hasChildren()) {
            CommandNode node = new ArrayList<CommandNode>(parent.getChildren()).getFirst();
            args.add(node);
            parent = node;
        }
        return args;
    }

    @NotNull
    public static List<CommandNode> getNodesPriorTo(@NotNull Collection<? extends CommandNode> source, @NotNull CommandNode target) {
        ArrayList<CommandNode> list = new ArrayList<CommandNode>();
        for (CommandNode commandNode : source) {
            if (commandNode == target) break;
            list.add(commandNode);
        }
        return list;
    }
}

