/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.nightcore.bridge.spigot.event;

import java.util.Set;
import java.util.function.Consumer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.bridge.chat.UniversalChatEvent;
import su.nightexpress.nightcore.bridge.chat.UniversalChatRenderer;
import su.nightexpress.nightcore.bridge.spigot.SpigotBridge;
import su.nightexpress.nightcore.util.bridge.wrapper.NightComponent;

public class SpigotChatEvent
implements UniversalChatEvent {
    private final AsyncPlayerChatEvent backend;

    public SpigotChatEvent(@NotNull SpigotBridge bridge, @NotNull AsyncPlayerChatEvent backend) {
        this.backend = backend;
    }

    @Override
    public boolean isCancelled() {
        return this.backend.isCancelled();
    }

    @Override
    public void setCancelled(boolean cancelled) {
        this.backend.setCancelled(cancelled);
    }

    @Override
    @NotNull
    public Player getPlayer() {
        return this.backend.getPlayer();
    }

    @Override
    @NotNull
    public Set<? extends CommandSender> viewers() {
        return this.backend.getRecipients();
    }

    @Override
    public void editViewers(@NotNull Consumer<Set<? extends CommandSender>> consumer) {
        consumer.accept(this.viewers());
    }

    @Override
    public void renderer(@NotNull UniversalChatRenderer renderer) {
        NightComponent component = renderer.render(this.backend.getPlayer(), this.backend.getPlayer().getDisplayName(), this.message(), null);
        this.backend.setFormat(component.toLegacy());
    }

    @Override
    @NotNull
    public String message() {
        return this.backend.getMessage();
    }

    @Override
    public void message(@NotNull NightComponent component) {
        this.backend.setMessage(component.toLegacy());
    }
}

