/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.nightcore.util.text.night.tag.handler;

import java.awt.Color;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.nightcore.util.Numbers;
import su.nightexpress.nightcore.util.text.night.ParserUtils;
import su.nightexpress.nightcore.util.text.night.entry.EntryGroup;
import su.nightexpress.nightcore.util.text.night.tag.TagContent;
import su.nightexpress.nightcore.util.text.night.tag.handler.ClassicTagHandler;

public class ShadowTagHandler
extends ClassicTagHandler {
    private static final float DEFAULT_ALPHA = 0.25f;
    private static final float MAX_ALPHA = 1.0f;

    @Override
    protected void onHandleOpen(@NotNull EntryGroup group, @Nullable String tagContent) {
        if (tagContent == null || tagContent.length() < 7) {
            return;
        }
        TagContent content = ParserUtils.parseInnerContent(tagContent);
        String alphaRaw = content.second();
        Color color = ParserUtils.colorFromSchemeOrHex(tagContent);
        if (color == null) {
            return;
        }
        float[] rgb = color.getRGBColorComponents(null);
        float alpha = alphaRaw == null ? 0.25f : Math.min(1.0f, Numbers.getFloatAbs(alphaRaw));
        group.setStyle(nightStyle -> nightStyle.shadowColor(new Color(rgb[0], rgb[1], rgb[2], alpha)));
    }

    @Override
    protected void onHandleClose(@NotNull EntryGroup group) {
    }
}

