/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.nightcore.util.text.night.tag.handler;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.nightcore.util.text.night.ParserUtils;
import su.nightexpress.nightcore.util.text.night.entry.ChildEntry;
import su.nightexpress.nightcore.util.text.night.entry.Entry;
import su.nightexpress.nightcore.util.text.night.entry.EntryGroup;
import su.nightexpress.nightcore.util.text.night.entry.LangEntry;
import su.nightexpress.nightcore.util.text.night.entry.TextEntry;
import su.nightexpress.nightcore.util.text.night.tag.handler.ClassicTagHandler;

public class GradientTagHandler
extends ClassicTagHandler {
    private Color[] colorStops;

    private Color[] createGradient(Color[] colorStops, int length) {
        Color[] gradient = new Color[length];
        int segments = colorStops.length - 1;
        int colorsPerSegment = length / segments;
        int remainder = length % segments;
        int index = 0;
        for (int i = 0; i < segments; ++i) {
            Color start = colorStops[i];
            Color end = colorStops[i + 1];
            int segmentLength = colorsPerSegment + (i < remainder ? 1 : 0);
            for (int j = 0; j < segmentLength; ++j) {
                double t = (double)j / (double)segmentLength;
                int r = (int)((double)start.getRed() + t * (double)(end.getRed() - start.getRed()));
                int g = (int)((double)start.getGreen() + t * (double)(end.getGreen() - start.getGreen()));
                int b = (int)((double)start.getBlue() + t * (double)(end.getBlue() - start.getBlue()));
                gradient[index++] = new Color(r, g, b);
            }
        }
        return gradient;
    }

    @Override
    protected void onHandleOpen(@NotNull EntryGroup group, @Nullable String tagContent) {
        if (tagContent == null) {
            return;
        }
        String[] split = tagContent.split(String.valueOf(':'));
        int length = split.length;
        if (length < 2) {
            return;
        }
        ArrayList<Color> colors = new ArrayList<Color>();
        for (String string : split) {
            Color stop = ParserUtils.colorFromSchemeOrHex(string);
            if (stop == null) continue;
            colors.add(stop);
        }
        this.colorStops = colors.toArray(new Color[0]);
    }

    @Override
    protected void onHandleClose(@NotNull EntryGroup group) {
        AtomicInteger textLength = new AtomicInteger(0);
        ArrayList<ChildEntry> gradientEntries = new ArrayList<ChildEntry>();
        this.splitGroup(group, textLength, gradientEntries, true);
        Color[] gradientColors = this.createGradient(this.colorStops, textLength.get());
        if (gradientColors.length == 0) {
            return;
        }
        Gradient gradient = new Gradient(gradientColors);
        gradientEntries.forEach(childEntry -> this.decorate((ChildEntry)childEntry, gradient));
    }

    private void splitGroup(@NotNull EntryGroup group, @NotNull AtomicInteger textLength, @NotNull List<ChildEntry> gradientEntries, boolean root) {
        ArrayList<Entry> childrens = new ArrayList<Entry>();
        ArrayList<Entry> oldChildrens = new ArrayList<Entry>(group.getChildrens());
        group.getChildrens().clear();
        oldChildrens.forEach(entry -> {
            if (entry instanceof EntryGroup) {
                EntryGroup other = (EntryGroup)entry;
                childrens.add(other);
                if (root && other.style().color() == group.style().color() && !other.isStyleLocked()) {
                    this.splitGroup(other, textLength, gradientEntries, false);
                }
                return;
            }
            if (entry instanceof ChildEntry) {
                ChildEntry childEntry = (ChildEntry)entry;
                textLength.addAndGet(childEntry.textLength());
                if (childEntry instanceof TextEntry) {
                    TextEntry textEntry = (TextEntry)childEntry;
                    for (char c : textEntry.text().toCharArray()) {
                        EntryGroup subGroup = group.downward(String.valueOf(c));
                        TextEntry subText = subGroup.appendTextEntry(String.valueOf(c));
                        childrens.add(subGroup);
                        if (Character.isWhitespace(c)) continue;
                        gradientEntries.add(subText);
                    }
                } else if (childEntry instanceof LangEntry) {
                    LangEntry langEntry = (LangEntry)childEntry;
                    EntryGroup subGroup = group.downward(langEntry.getKey());
                    LangEntry subTrans = subGroup.appendLangEntry(langEntry.getKey(), langEntry.getFallback());
                    childrens.add(subGroup);
                    gradientEntries.add(subTrans);
                }
            }
        });
        group.setChildrens(childrens);
    }

    private void decorate(@NotNull ChildEntry entry, @NotNull Gradient gradient) {
        if (!gradient.hasNextColor()) {
            return;
        }
        entry.getParent().setStyle(style -> style.color(gradient.nextColor()));
    }

    private static class Gradient {
        private final Color[] colors;
        private int colorIndex;

        public Gradient(Color[] colors) {
            this.colors = colors;
            this.colorIndex = 0;
        }

        public boolean hasNextColor() {
            return this.colorIndex < this.colors.length;
        }

        @NotNull
        public Color nextColor() {
            return this.colors[this.colorIndex++];
        }
    }
}

