/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.nightcore.util.number;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.nightcore.util.NumberUtil;
import su.nightexpress.nightcore.util.number.NumberShortcut;

public class CompactNumber {
    private final double value;
    private final NumberShortcut shortcut;

    public CompactNumber(double value, @Nullable NumberShortcut shortcut) {
        this.value = value;
        this.shortcut = shortcut;
    }

    @NotNull
    public String format() {
        Object num = NumberUtil.format(NumberUtil.round(this.value, 1));
        if (this.shortcut != null) {
            num = (String)num + this.shortcut.getSymbol();
        }
        return num;
    }

    public double getValue() {
        return this.value;
    }

    @Nullable
    public NumberShortcut getShortcut() {
        return this.shortcut;
    }
}

