/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.nightcore.util;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.util.time.TimeFormatType;
import su.nightexpress.nightcore.util.time.TimeFormats;

public class TimeUtil {
    private static TimeZone timeZone;

    public static void setTimeZone(@NotNull String name) {
        timeZone = TimeZone.getTimeZone(name);
    }

    @NotNull
    public static TimeZone getTimeZone() {
        return timeZone;
    }

    @NotNull
    public static ZoneId getZoneId() {
        return timeZone.toZoneId();
    }

    @Deprecated
    @NotNull
    public static String formatTime(long time) {
        return TimeFormats.toLiteral(time);
    }

    public static boolean isPassed(long timestamp) {
        return timestamp >= 0L && System.currentTimeMillis() > timestamp;
    }

    public static long createFutureTimestamp(double seconds) {
        return seconds < 0.0 ? -1L : TimeUtil.createTimestamp(Math.abs(seconds));
    }

    public static long createPastTimestamp(double seconds) {
        return TimeUtil.createTimestamp(-Math.abs(seconds));
    }

    public static long createTimestamp(double seconds) {
        return System.currentTimeMillis() + (long)(seconds * 1000.0);
    }

    public static long secondsToTicks(int seconds) {
        return (long)seconds * 20L;
    }

    public static double ticksToSeconds(long ticks) {
        return (double)ticks / 20.0;
    }

    @Deprecated
    @NotNull
    public static String formatDuration(long from, long to) {
        long time = to - from;
        return TimeFormats.toLiteral(time);
    }

    @Deprecated
    @NotNull
    public static String formatDuration(long until) {
        return TimeFormats.formatDuration(until, TimeFormatType.LITERAL);
    }

    @NotNull
    public static LocalTime getLocalTimeOf(long ms) {
        long hours = TimeUnit.MILLISECONDS.toHours(ms) % 24L;
        long minutes = TimeUnit.MILLISECONDS.toMinutes(ms) % 60L;
        long seconds = TimeUnit.MILLISECONDS.toSeconds(ms) % 60L;
        return LocalTime.of((int)hours, (int)minutes, (int)seconds);
    }

    @NotNull
    public static LocalDateTime getCurrentDateTime() {
        return LocalDateTime.now(TimeUtil.getZoneId());
    }

    @NotNull
    public static LocalDate getCurrentDate() {
        return LocalDate.now(TimeUtil.getZoneId());
    }

    @NotNull
    public static LocalTime getCurrentTime() {
        return LocalTime.now(TimeUtil.getZoneId());
    }

    @NotNull
    public static LocalDateTime getLocalDateTimeOf(long ms) {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(ms), TimeUtil.getZoneId());
    }

    public static long toEpochMillis(@NotNull LocalDateTime dateTime) {
        Instant instant = dateTime.atZone(TimeUtil.getZoneId()).toInstant();
        return instant.toEpochMilli();
    }
}

