/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.nightcore.util;

import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataAdapterContext;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.nightcore.util.ItemUtil;

public class PDCUtil {
    public static final PersistentDataType<byte[], UUID> UUID = new UUIDDataType();

    @NotNull
    public static <Z> Optional<Z> get(@NotNull ItemStack holder, @NotNull PersistentDataType<?, Z> type, @NotNull NamespacedKey key) {
        ItemMeta meta = holder.getItemMeta();
        if (meta == null) {
            return Optional.empty();
        }
        return PDCUtil.get((PersistentDataHolder)meta, type, key);
    }

    @NotNull
    public static <Z> Optional<Z> get(@NotNull PersistentDataHolder holder, @NotNull PersistentDataType<?, Z> type, @NotNull NamespacedKey key) {
        PersistentDataContainer container = holder.getPersistentDataContainer();
        if (container.has(key, type)) {
            return Optional.ofNullable(container.get(key, type));
        }
        return Optional.empty();
    }

    public static void set(@NotNull ItemStack holder, @NotNull NamespacedKey key, boolean value) {
        PDCUtil.set(holder, PersistentDataType.INTEGER, key, Integer.valueOf(value ? 1 : 0));
    }

    public static void set(@NotNull PersistentDataHolder holder, @NotNull NamespacedKey key, boolean value) {
        PDCUtil.set(holder, PersistentDataType.INTEGER, key, Integer.valueOf(value ? 1 : 0));
    }

    public static void set(@NotNull ItemStack holder, @NotNull NamespacedKey key, double value) {
        PDCUtil.set(holder, PersistentDataType.DOUBLE, key, Double.valueOf(value));
    }

    public static void set(@NotNull PersistentDataHolder holder, @NotNull NamespacedKey key, double value) {
        PDCUtil.set(holder, PersistentDataType.DOUBLE, key, Double.valueOf(value));
    }

    public static void set(@NotNull ItemStack holder, @NotNull NamespacedKey key, int value) {
        PDCUtil.set(holder, PersistentDataType.INTEGER, key, Integer.valueOf(value));
    }

    public static void set(@NotNull PersistentDataHolder holder, @NotNull NamespacedKey key, int value) {
        PDCUtil.set(holder, PersistentDataType.INTEGER, key, Integer.valueOf(value));
    }

    public static void set(@NotNull ItemStack holder, @NotNull NamespacedKey key, long value) {
        PDCUtil.set(holder, PersistentDataType.LONG, key, Long.valueOf(value));
    }

    public static void set(@NotNull PersistentDataHolder holder, @NotNull NamespacedKey key, long value) {
        PDCUtil.set(holder, PersistentDataType.LONG, key, Long.valueOf(value));
    }

    public static void set(@NotNull ItemStack holder, @NotNull NamespacedKey key, @Nullable String value) {
        PDCUtil.set(holder, PersistentDataType.STRING, key, value);
    }

    public static void set(@NotNull PersistentDataHolder holder, @NotNull NamespacedKey key, @Nullable String value) {
        PDCUtil.set(holder, PersistentDataType.STRING, key, value);
    }

    public static void set(@NotNull ItemStack holder, @NotNull NamespacedKey key, @Nullable UUID value) {
        PDCUtil.set(holder, UUID, key, value);
    }

    public static void set(@NotNull PersistentDataHolder holder, @NotNull NamespacedKey key, @Nullable UUID value) {
        PDCUtil.set(holder, UUID, key, value);
    }

    public static <T, Z> void set(@NotNull ItemStack item, @NotNull PersistentDataType<T, Z> dataType, @NotNull NamespacedKey key, @Nullable Z value) {
        ItemUtil.editMeta(item, meta -> PDCUtil.set((PersistentDataHolder)meta, dataType, key, value));
    }

    public static <T, Z> void set(@NotNull PersistentDataHolder holder, @NotNull PersistentDataType<T, Z> dataType, @NotNull NamespacedKey key, @Nullable Z value) {
        if (value == null) {
            PDCUtil.remove(holder, key);
            return;
        }
        PersistentDataContainer container = holder.getPersistentDataContainer();
        container.set(key, dataType, value);
    }

    public static void remove(@NotNull ItemStack holder, @NotNull NamespacedKey key) {
        ItemUtil.editMeta(holder, meta -> PDCUtil.remove((PersistentDataHolder)meta, key));
    }

    public static void remove(@NotNull PersistentDataHolder holder, @NotNull NamespacedKey key) {
        PersistentDataContainer container = holder.getPersistentDataContainer();
        container.remove(key);
    }

    @NotNull
    public static Optional<String> getString(@NotNull ItemStack holder, @NotNull NamespacedKey key) {
        return PDCUtil.get(holder, PersistentDataType.STRING, key);
    }

    @NotNull
    public static Optional<String> getString(@NotNull PersistentDataHolder holder, @NotNull NamespacedKey key) {
        return PDCUtil.get(holder, PersistentDataType.STRING, key);
    }

    @NotNull
    public static Optional<Integer> getInt(@NotNull ItemStack holder, @NotNull NamespacedKey key) {
        return PDCUtil.get(holder, PersistentDataType.INTEGER, key);
    }

    @NotNull
    public static Optional<Integer> getInt(@NotNull PersistentDataHolder holder, @NotNull NamespacedKey key) {
        return PDCUtil.get(holder, PersistentDataType.INTEGER, key);
    }

    @NotNull
    public static Optional<Long> getLong(@NotNull ItemStack holder, @NotNull NamespacedKey key) {
        return PDCUtil.get(holder, PersistentDataType.LONG, key);
    }

    @NotNull
    public static Optional<Long> getLong(@NotNull PersistentDataHolder holder, @NotNull NamespacedKey key) {
        return PDCUtil.get(holder, PersistentDataType.LONG, key);
    }

    @NotNull
    public static Optional<Double> getDouble(@NotNull ItemStack holder, @NotNull NamespacedKey key) {
        return PDCUtil.get(holder, PersistentDataType.DOUBLE, key);
    }

    @NotNull
    public static Optional<Double> getDouble(@NotNull PersistentDataHolder holder, @NotNull NamespacedKey key) {
        return PDCUtil.get(holder, PersistentDataType.DOUBLE, key);
    }

    @NotNull
    public static Optional<Boolean> getBoolean(@NotNull ItemStack holder, @NotNull NamespacedKey key) {
        return PDCUtil.get(holder, PersistentDataType.INTEGER, key).map(i -> i != 0);
    }

    @NotNull
    public static Optional<Boolean> getBoolean(@NotNull PersistentDataHolder holder, @NotNull NamespacedKey key) {
        return PDCUtil.get(holder, PersistentDataType.INTEGER, key).map(i -> i != 0);
    }

    @NotNull
    public static Optional<UUID> getUUID(@NotNull ItemStack holder, @NotNull NamespacedKey key) {
        return PDCUtil.get(holder, UUID, key);
    }

    @NotNull
    public static Optional<UUID> getUUID(@NotNull PersistentDataHolder holder, @NotNull NamespacedKey key) {
        return PDCUtil.get(holder, UUID, key);
    }

    public static class UUIDDataType
    implements PersistentDataType<byte[], UUID> {
        @NotNull
        public Class<byte[]> getPrimitiveType() {
            return byte[].class;
        }

        @NotNull
        public Class<UUID> getComplexType() {
            return UUID.class;
        }

        public byte @NotNull [] toPrimitive(UUID complex, @NotNull PersistentDataAdapterContext context) {
            ByteBuffer bb = ByteBuffer.wrap(new byte[16]);
            bb.putLong(complex.getMostSignificantBits());
            bb.putLong(complex.getLeastSignificantBits());
            return bb.array();
        }

        @NotNull
        public UUID fromPrimitive(byte @NotNull [] primitive, @NotNull PersistentDataAdapterContext context) {
            ByteBuffer bb = ByteBuffer.wrap(primitive);
            long firstLong = bb.getLong();
            long secondLong = bb.getLong();
            return new UUID(firstLong, secondLong);
        }
    }
}

