/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.nightcore.util;

import java.util.Optional;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class Numbers {
    public static int getIntegerAbs(@NotNull String input) {
        return Numbers.getIntegerAbs(input, 0);
    }

    public static int getIntegerAbs(@NotNull String input, int defaultValue) {
        return Math.abs(Numbers.getAnyInteger(input, defaultValue));
    }

    public static int getAnyInteger(@NotNull String input, int defaultValue) {
        return Numbers.parseInteger(input).orElse(defaultValue);
    }

    @NotNull
    public static Optional<Integer> parseInteger(@NotNull String input) {
        return Numbers.parseNumber(input, Integer::parseInt);
    }

    public static long getLongAbs(@NotNull String input) {
        return Numbers.getLongAbs(input, 0L);
    }

    public static long getLongAbs(@NotNull String input, long defaultValue) {
        return Math.abs(Numbers.getAnyLong(input, defaultValue));
    }

    public static long getAnyLong(@NotNull String input, long defaultValue) {
        return Numbers.parseLong(input).orElse(defaultValue);
    }

    @NotNull
    public static Optional<Long> parseLong(@NotNull String input) {
        return Numbers.parseNumber(input, Long::parseLong);
    }

    public static float getFloatAbs(@NotNull String input) {
        return Numbers.getFloatAbs(input, 0.0f);
    }

    public static float getFloatAbs(@NotNull String input, float defaultValue) {
        return Math.abs(Numbers.getFloat(input, defaultValue));
    }

    public static float getFloat(@NotNull String input, float defaultValue) {
        return Numbers.parseFloat(input).orElse(Float.valueOf(defaultValue)).floatValue();
    }

    @NotNull
    public static Optional<Float> parseFloat(@NotNull String input) {
        return Numbers.parseNumber(input, string -> {
            float amount = Float.parseFloat(input);
            return !Float.isNaN(amount) && !Float.isInfinite(amount) ? Float.valueOf(amount) : null;
        });
    }

    public static double getDoubleAbs(@NotNull String input) {
        return Numbers.getDoubleAbs(input, 0.0);
    }

    public static double getDoubleAbs(@NotNull String input, double defaultValue) {
        return Math.abs(Numbers.getDouble(input, defaultValue));
    }

    public static double getDouble(@NotNull String input, double defaultValue) {
        return Numbers.parseDouble(input).orElse(defaultValue);
    }

    @NotNull
    public static Optional<Double> parseDouble(@NotNull String input) {
        return Numbers.parseNumber(input, string -> {
            double amount = Double.parseDouble(input);
            return !Double.isNaN(amount) && !Double.isInfinite(amount) ? Double.valueOf(amount) : null;
        });
    }

    @NotNull
    private static <T> Optional<T> parseNumber(@NotNull String input, @NotNull Function<String, T> converter) {
        if (input.isBlank()) {
            return Optional.empty();
        }
        try {
            T value = converter.apply(input);
            return value == null ? Optional.empty() : Optional.of(value);
        }
        catch (NumberFormatException ignored) {
            return Optional.empty();
        }
    }
}

