/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.nightcore.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.inventory.meta.components.CustomModelDataComponent;
import org.bukkit.profile.PlayerProfile;
import org.bukkit.profile.PlayerTextures;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.nightcore.bridge.wrap.NightProfile;
import su.nightexpress.nightcore.util.ItemNbt;
import su.nightexpress.nightcore.util.LangUtil;
import su.nightexpress.nightcore.util.Lists;
import su.nightexpress.nightcore.util.Version;
import su.nightexpress.nightcore.util.bridge.Software;
import su.nightexpress.nightcore.util.bridge.wrapper.NightComponent;
import su.nightexpress.nightcore.util.profile.CachedProfile;
import su.nightexpress.nightcore.util.profile.PlayerProfiles;
import su.nightexpress.nightcore.util.text.night.NightMessage;
import su.nightexpress.nightcore.util.text.night.ParserUtils;
import su.nightexpress.nightcore.util.text.night.tag.TagPool;

public class ItemUtil {
    public static final String TEXTURES_HOST = "http://textures.minecraft.net/texture/";

    public static void editMeta(@NotNull ItemStack item, @NotNull Consumer<ItemMeta> consumer) {
        Software.get().editMeta(item, consumer);
    }

    public static <T extends ItemMeta> void editMeta(@NotNull ItemStack item, @NotNull Class<T> clazz, @NotNull Consumer<T> consumer) {
        Software.get().editMeta(item, clazz, consumer);
    }

    @NotNull
    public static String getNameSerialized(@NotNull ItemStack itemStack) {
        String metaName;
        ItemMeta meta = itemStack.getItemMeta();
        String string = metaName = meta == null ? null : ItemUtil.getNameSerialized(meta);
        if (metaName != null) {
            return metaName;
        }
        return LangUtil.getSerializedName(itemStack.getType());
    }

    @Nullable
    public static String getDisplayNameSerialized(@NotNull ItemStack itemStack) {
        ItemMeta meta = itemStack.getItemMeta();
        if (meta == null) {
            return null;
        }
        return ItemUtil.getNameSerialized(meta);
    }

    @Nullable
    public static String getNameSerialized(@NotNull ItemMeta meta) {
        String customName = ItemUtil.getCustomNameSerialized(meta);
        if (customName != null) {
            return customName;
        }
        return ItemUtil.getItemNameSerialized(meta);
    }

    @Deprecated
    @NotNull
    public static String getItemName(@NotNull ItemStack item) {
        return ItemUtil.getNameSerialized(item);
    }

    @Deprecated
    @Nullable
    public static String getItemName(@NotNull ItemMeta meta) {
        return ItemUtil.getNameSerialized(meta);
    }

    @Deprecated
    @NotNull
    public static String getSerializedName(@NotNull ItemStack item) {
        return ItemUtil.getNameSerialized(item);
    }

    @Deprecated
    @Nullable
    public static String getSerializedName(@NotNull ItemMeta meta) {
        return ItemUtil.getNameSerialized(meta);
    }

    @Deprecated
    @Nullable
    public static String getSerializedDisplayName(@NotNull ItemMeta meta) {
        return ItemUtil.getCustomNameSerialized(meta);
    }

    @Deprecated
    @Nullable
    public static String getSerializedItemName(@NotNull ItemMeta meta) {
        return ItemUtil.getItemNameSerialized(meta);
    }

    @Deprecated
    @NotNull
    public static List<String> getSerializedLore(@NotNull ItemStack item) {
        return ItemUtil.getLoreSerialized(item);
    }

    @Deprecated
    @NotNull
    public static List<String> getSerializedLore(@NotNull ItemMeta meta) {
        return ItemUtil.getLoreSerialized(meta);
    }

    @Deprecated
    public static void setDisplayName(@NotNull ItemMeta meta, @NotNull String name) {
        ItemUtil.setCustomName(meta, name);
    }

    @Nullable
    public static String getCustomNameSerialized(@NotNull ItemStack itemStack) {
        ItemMeta meta = itemStack.getItemMeta();
        return meta == null ? null : ItemUtil.getCustomNameSerialized(meta);
    }

    @Nullable
    public static String getCustomNameSerialized(@NotNull ItemMeta meta) {
        String name = Software.get().getCustomName(meta);
        return name == null ? null : NightMessage.stripTags(name, TagPool.NO_INVERTED_DECORATIONS);
    }

    public static void setCustomName(@NotNull ItemMeta meta, @NotNull String name) {
        Software.get().setCustomName(meta, NightMessage.parse(name));
    }

    public static void setCustomName(@NotNull ItemMeta meta, @Nullable NightComponent name) {
        Software.get().setCustomName(meta, name);
    }

    @Nullable
    public static String getItemNameSerialized(@NotNull ItemStack itemStack) {
        ItemMeta meta = itemStack.getItemMeta();
        return meta == null ? null : ItemUtil.getItemNameSerialized(meta);
    }

    @Nullable
    public static String getItemNameSerialized(@NotNull ItemMeta meta) {
        String name = Software.get().getItemName(meta);
        return name == null ? null : NightMessage.stripTags(name, TagPool.NO_INVERTED_DECORATIONS);
    }

    public static void setItemName(@NotNull ItemMeta meta, @NotNull String name) {
        Software.get().setItemName(meta, NightMessage.parse(name));
    }

    @Deprecated
    @NotNull
    public static List<String> getLore(@NotNull ItemStack item) {
        ItemMeta meta = item.getItemMeta();
        return meta == null || meta.getLore() == null ? new ArrayList() : meta.getLore();
    }

    @NotNull
    public static List<String> getLoreSerialized(@NotNull ItemStack itemStack) {
        ItemMeta meta = itemStack.getItemMeta();
        return meta == null ? new ArrayList() : ItemUtil.getLoreSerialized(meta);
    }

    @NotNull
    public static List<String> getLoreSerialized(@NotNull ItemMeta meta) {
        List<String> lore = Software.get().getLore(meta);
        return lore == null ? new ArrayList() : Lists.modify(lore, line -> NightMessage.stripTags(line, TagPool.NO_INVERTED_DECORATIONS));
    }

    public static void setLore(@NotNull ItemMeta meta, @NotNull List<String> lore) {
        ItemUtil.setItemLore(meta, Lists.modify(ParserUtils.breakDownLineSplitters(lore), NightMessage::parse));
    }

    public static void setItemLore(@NotNull ItemMeta meta, @NotNull List<NightComponent> lore) {
        Software.get().setLore(meta, lore);
    }

    @Deprecated
    public static void hideAttributes(@NotNull ItemStack itemStack) {
        if (Version.isAtLeast(Version.MC_1_21_5)) {
            Software.get().hideComponents(itemStack);
            return;
        }
        ItemUtil.editMeta(itemStack, meta -> ItemUtil.hideAttributes(meta, itemStack.getType()));
    }

    @Deprecated
    private static void hideAttributes(@NotNull ItemMeta meta, @NotNull Material material) {
        if (Version.isBehind(Version.MC_1_21_5) && Version.isAtLeast(Version.MC_1_20_6) && material.isItem()) {
            EquipmentSlot slot = material.getEquipmentSlot();
            material.getDefaultAttributeModifiers(slot).forEach((attribute, modifier) -> {
                Collection modifiers;
                Collection collection = modifiers = meta.getAttributeModifiers() == null ? null : meta.getAttributeModifiers(attribute);
                if (modifiers == null || modifiers.isEmpty() || !meta.getAttributeModifiers().containsKey(attribute)) {
                    meta.addAttributeModifier(attribute, modifier);
                }
            });
        }
        meta.addItemFlags(ItemFlag.values());
    }

    public static void setCustomModelData(@NotNull ItemStack itemStack, float data) {
        ItemUtil.editMeta(itemStack, meta -> ItemUtil.setCustomModelData(meta, data));
    }

    public static void setCustomModelData(@NotNull ItemMeta meta, float data) {
        if (Version.isAtLeast(Version.MC_1_21_5)) {
            CustomModelDataComponent component = meta.getCustomModelDataComponent();
            component.setFloats(Lists.newList(Float.valueOf(data)));
            meta.setCustomModelDataComponent(component);
        } else {
            meta.setCustomModelData(Integer.valueOf((int)data));
        }
    }

    @Nullable
    public static Float getCustomModelData(@NotNull ItemStack itemStack) {
        ItemMeta meta = itemStack.getItemMeta();
        return meta == null ? null : ItemUtil.getCustomModelData(meta);
    }

    @Nullable
    public static Float getCustomModelData(@NotNull ItemMeta meta) {
        if (Version.isAtLeast(Version.MC_1_21_5)) {
            List floats = meta.getCustomModelDataComponent().getFloats();
            return floats.isEmpty() ? null : (Float)floats.getFirst();
        }
        return meta.hasCustomModelData() ? Float.valueOf(meta.getCustomModelData()) : null;
    }

    @Deprecated
    @NotNull
    public static ItemStack createCustomHead(@NotNull String texture) {
        ItemStack item = new ItemStack(Material.PLAYER_HEAD);
        ItemUtil.setSkullTexture(item, texture);
        return item;
    }

    @Deprecated
    @NotNull
    public static ItemStack getSkinHead(@NotNull String texture) {
        return ItemUtil.getCustomHead(texture);
    }

    @NotNull
    public static ItemStack getCustomHead(@NotNull String texture) {
        ItemStack item = new ItemStack(Material.PLAYER_HEAD);
        ItemUtil.setProfileBySkinURL(item, texture);
        return item;
    }

    @Deprecated
    @Nullable
    public static PlayerProfile createSkinProfile(@NotNull String urlData) {
        if (((String)urlData).isBlank()) {
            return null;
        }
        String name = ((String)urlData).substring(0, 16);
        if (!((String)urlData).startsWith(TEXTURES_HOST)) {
            urlData = TEXTURES_HOST + (String)urlData;
        }
        try {
            UUID uuid = UUID.nameUUIDFromBytes(((String)urlData).getBytes());
            PlayerProfile profile = Bukkit.createPlayerProfile((UUID)uuid, (String)name);
            URL url = URI.create((String)urlData).toURL();
            PlayerTextures textures = profile.getTextures();
            textures.setSkin(url);
            profile.setTextures(textures);
            return profile;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    @Deprecated
    public static void setHeadSkin(@NotNull ItemStack item, @NotNull String urlData) {
        ItemUtil.setProfileBySkinURL(item, urlData);
    }

    @Deprecated
    @Nullable
    public static String getHeadSkin(@NotNull ItemStack item) {
        return ItemUtil.getProfileSkinURL(item);
    }

    @Nullable
    public static NightProfile getOwnerProfile(@NotNull ItemStack itemStack) {
        return Software.get().getOwnerProfile(itemStack);
    }

    @Nullable
    public static String getProfileSkinURL(@NotNull ItemStack itemStack) {
        NightProfile profile = ItemUtil.getOwnerProfile(itemStack);
        if (profile == null) {
            return null;
        }
        return PlayerProfiles.getProfileSkinURL(profile);
    }

    public static void setProfileBySkinURL(@NotNull ItemStack itemStack, @NotNull String urlData) {
        CachedProfile profile = PlayerProfiles.createProfileBySkinURL(urlData);
        if (profile == null) {
            return;
        }
        ItemUtil.editMeta(itemStack, SkullMeta.class, skullMeta -> profile.query().apply((SkullMeta)skullMeta));
    }

    @Deprecated
    public static void setSkullTexture(@NotNull ItemStack item, @NotNull String value) {
        if (item.getType() != Material.PLAYER_HEAD) {
            return;
        }
        try {
            byte[] decoded = Base64.getDecoder().decode(value);
            String decodedStr = new String(decoded, StandardCharsets.UTF_8);
            JsonElement element = JsonParser.parseString((String)decodedStr);
            String url = element.getAsJsonObject().getAsJsonObject("textures").getAsJsonObject("SKIN").get("url").getAsString();
            url = url.substring(TEXTURES_HOST.length());
            ItemUtil.setProfileBySkinURL(item, url);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static boolean isTool(@NotNull ItemStack item) {
        return ItemUtil.isAxe(item) || ItemUtil.isHoe(item) || ItemUtil.isPickaxe(item) || ItemUtil.isShovel(item);
    }

    public static boolean isArmor(@NotNull ItemStack item) {
        return ItemUtil.isHelmet(item) || ItemUtil.isChestplate(item) || ItemUtil.isLeggings(item) || ItemUtil.isBoots(item);
    }

    public static boolean isBow(@NotNull ItemStack item) {
        return item.getType() == Material.BOW || item.getType() == Material.CROSSBOW;
    }

    public static boolean isSword(@NotNull ItemStack item) {
        return Tag.ITEMS_SWORDS.isTagged((Keyed)item.getType());
    }

    public static boolean isAxe(@NotNull ItemStack item) {
        return Tag.ITEMS_AXES.isTagged((Keyed)item.getType());
    }

    @Deprecated
    public static boolean isTrident(@NotNull ItemStack item) {
        return item.getType() == Material.TRIDENT;
    }

    public static boolean isPickaxe(@NotNull ItemStack item) {
        return Tag.ITEMS_PICKAXES.isTagged((Keyed)item.getType());
    }

    public static boolean isShovel(@NotNull ItemStack item) {
        return Tag.ITEMS_SHOVELS.isTagged((Keyed)item.getType());
    }

    public static boolean isHoe(@NotNull ItemStack item) {
        return Tag.ITEMS_HOES.isTagged((Keyed)item.getType());
    }

    @Deprecated
    public static boolean isElytra(@NotNull ItemStack item) {
        return item.getType() == Material.ELYTRA;
    }

    @Deprecated
    public static boolean isFishingRod(@NotNull ItemStack item) {
        return item.getType() == Material.FISHING_ROD;
    }

    public static boolean isHelmet(@NotNull ItemStack item) {
        return ItemUtil.getEquipmentSlot(item) == EquipmentSlot.HEAD;
    }

    public static boolean isChestplate(@NotNull ItemStack item) {
        return ItemUtil.getEquipmentSlot(item) == EquipmentSlot.CHEST;
    }

    public static boolean isLeggings(@NotNull ItemStack item) {
        return ItemUtil.getEquipmentSlot(item) == EquipmentSlot.LEGS;
    }

    public static boolean isBoots(@NotNull ItemStack item) {
        return ItemUtil.getEquipmentSlot(item) == EquipmentSlot.FEET;
    }

    @NotNull
    public static EquipmentSlot getEquipmentSlot(@NotNull ItemStack item) {
        Material material = item.getType();
        return material.isItem() ? material.getEquipmentSlot() : EquipmentSlot.HAND;
    }

    @Deprecated
    @Nullable
    public static String compress(@NotNull ItemStack item) {
        return ItemNbt.compress(item);
    }

    @Deprecated
    @Nullable
    public static ItemStack decompress(@NotNull String compressed) {
        return ItemNbt.decompress(compressed);
    }

    @Deprecated
    @NotNull
    public static List<String> compress(@NotNull ItemStack[] items) {
        return ItemNbt.compress(Arrays.asList(items));
    }

    @Deprecated
    @NotNull
    public static List<String> compress(@NotNull List<ItemStack> items) {
        return new ArrayList<String>(items.stream().map(ItemNbt::compress).filter(Objects::nonNull).toList());
    }

    @Deprecated
    public static ItemStack[] decompress(@NotNull List<String> list) {
        List<ItemStack> items = list.stream().map(ItemNbt::decompress).filter(Objects::nonNull).toList();
        return items.toArray(new ItemStack[list.size()]);
    }
}

