/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.nightcore.language;

import java.io.File;
import java.io.InputStream;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.Engine;
import su.nightexpress.nightcore.NightCorePlugin;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.language.entry.LangElement;
import su.nightexpress.nightcore.manager.SimpleManager;
import su.nightexpress.nightcore.util.Reflex;
import su.nightexpress.nightcore.util.StringUtil;

@Deprecated
public class LangManager
extends SimpleManager<NightCorePlugin> {
    public static final String DEFAULT_LANGUAGE = "en";
    public static final String DIR_LANG = "/lang/";
    private FileConfig config;

    public LangManager(@NotNull NightCorePlugin plugin) {
        super(plugin);
    }

    @Override
    protected void onLoad() {
        this.plugin.extractResources(DIR_LANG);
        String langCode = this.plugin.getLanguage();
        String realCode = this.validateConfig(langCode);
        this.config = FileConfig.loadOrExtract(this.plugin, DIR_LANG, this.getFileName(realCode));
    }

    @Override
    protected void onShutdown() {
    }

    private boolean isPacked(@NotNull String filePath) {
        boolean bl;
        block9: {
            if (!((String)filePath).startsWith("/")) {
                filePath = "/" + (String)filePath;
            }
            InputStream inputStream = this.plugin.getClass().getResourceAsStream((String)filePath);
            try {
                boolean bl2 = bl = inputStream != null;
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    return false;
                }
            }
            inputStream.close();
        }
        return bl;
    }

    @NotNull
    private String validateConfig(@NotNull String langCode) {
        String fileName = this.getFileName(langCode);
        File file = new File(String.valueOf(this.plugin.getDataFolder()) + DIR_LANG, fileName);
        if (!file.exists() && !LangManager.isDefault(langCode)) {
            if (this.isPacked(DIR_LANG + fileName)) {
                return langCode;
            }
            this.plugin.warn("Locale file for '" + langCode + "' language not found. Using default 'en' locale.");
            return DEFAULT_LANGUAGE;
        }
        return langCode;
    }

    public void loadEntries(@NotNull Class<?> clazz) {
        Reflex.getStaticFields(clazz, LangElement.class, false).forEach(entry -> entry.load(this.plugin));
    }

    @Deprecated
    public void loadEnum(@NotNull Class<? extends Enum<?>> clazz) {
        for (Enum<?> eName : clazz.getEnumConstants()) {
            String name = eName.toString();
            String path = clazz.getSimpleName() + "." + name;
            String val = StringUtil.capitalizeUnderscored(name);
            this.getConfig().addMissing(path, val);
        }
    }

    @Deprecated
    @NotNull
    public String getEnum(@NotNull Enum<?> entry) {
        String path = entry.getDeclaringClass().getSimpleName() + "." + entry.name();
        String locEnum = this.config.getString(path);
        if (locEnum == null && Engine.core() != this.plugin) {
            return Engine.core().getLangManager().getEnum(entry);
        }
        return locEnum == null ? StringUtil.capitalizeFully(entry.name()) : locEnum;
    }

    public static boolean isDefault(@NotNull String langCode) {
        return langCode.equalsIgnoreCase(DEFAULT_LANGUAGE);
    }

    @NotNull
    public String getFileName(@NotNull String langCode) {
        return "messages_" + langCode + ".yml";
    }

    @NotNull
    public FileConfig getConfig() {
        return this.config;
    }
}

