/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.nightcore.commands.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.commands.builder.ArgumentNodeBuilder;
import su.nightexpress.nightcore.commands.builder.ExecutableNodeBuilder;
import su.nightexpress.nightcore.commands.tree.ArgumentNode;
import su.nightexpress.nightcore.commands.tree.CommandNode;
import su.nightexpress.nightcore.commands.tree.FlagNode;
import su.nightexpress.nightcore.commands.tree.LiteralNode;

public class LiteralNodeBuilder
extends ExecutableNodeBuilder<LiteralNode, LiteralNodeBuilder> {
    private final List<ArgumentNode<?>> arguments = new ArrayList();
    private final List<FlagNode> flags = new ArrayList<FlagNode>();

    public LiteralNodeBuilder(@NotNull String literal) {
        super(literal);
    }

    @Override
    @NotNull
    protected LiteralNodeBuilder getThis() {
        return this;
    }

    @NotNull
    public LiteralNodeBuilder withArguments(ArgumentNodeBuilder<?> ... argument) {
        for (ArgumentNodeBuilder<?> builder : argument) {
            this.arguments.add((ArgumentNode<?>)builder.build());
        }
        return this.getThis();
    }

    @NotNull
    public LiteralNodeBuilder withArguments(ArgumentNode<?> ... argument) {
        this.arguments.addAll(Arrays.asList(argument));
        return this.getThis();
    }

    @NotNull
    public LiteralNodeBuilder withFlags(String ... flags) {
        for (String name : flags) {
            this.withFlags(new FlagNode(name));
        }
        return this.getThis();
    }

    @NotNull
    public LiteralNodeBuilder withFlags(FlagNode ... flags) {
        this.flags.addAll(Arrays.asList(flags));
        return this.getThis();
    }

    @Override
    @NotNull
    public LiteralNode build() {
        LiteralNode result = new LiteralNode(this.name, this.description, this.permission, this.requirements, this.executor);
        ArrayList<CommandNode> args = new ArrayList<CommandNode>();
        args.addAll(this.arguments);
        args.addAll(this.flags);
        result.setArguments(args);
        return result;
    }
}

