/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.nightcore.bridge.spigot;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.md_5.bungee.api.dialog.Dialog;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Translatable;
import org.bukkit.attribute.Attribute;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.command.Command;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MenuType;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.inventory.view.builder.InventoryViewBuilder;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.profile.PlayerProfile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.nightcore.bridge.bossbar.NightBarColor;
import su.nightexpress.nightcore.bridge.bossbar.NightBarFlag;
import su.nightexpress.nightcore.bridge.bossbar.NightBarOverlay;
import su.nightexpress.nightcore.bridge.dialog.adapter.DialogAdapter;
import su.nightexpress.nightcore.bridge.dialog.response.DialogClickHandler;
import su.nightexpress.nightcore.bridge.dialog.wrap.WrappedDialog;
import su.nightexpress.nightcore.bridge.spigot.SpigotProfile;
import su.nightexpress.nightcore.bridge.spigot.bossbar.SpigotBossBar;
import su.nightexpress.nightcore.bridge.spigot.bossbar.SpigotBossBarAdapter;
import su.nightexpress.nightcore.bridge.spigot.dialog.SpigotDialogAdapter;
import su.nightexpress.nightcore.bridge.spigot.dialog.SpigotDialogListener;
import su.nightexpress.nightcore.bridge.spigot.text.SpigotTextComponentAdapter;
import su.nightexpress.nightcore.bridge.wrap.NightProfile;
import su.nightexpress.nightcore.util.Enums;
import su.nightexpress.nightcore.util.LegacyColors;
import su.nightexpress.nightcore.util.Lists;
import su.nightexpress.nightcore.util.Reflex;
import su.nightexpress.nightcore.util.Version;
import su.nightexpress.nightcore.util.bridge.Software;
import su.nightexpress.nightcore.util.bridge.wrapper.NightComponent;

public class SpigotBridge
implements Software {
    private static final String FIELD_COMMAND_MAP = "commandMap";
    private static final String FIELD_KNOWN_COMMANDS = "knownCommands";
    private static SimpleCommandMap commandMap;
    private static AtomicInteger entityCounter;
    private SpigotTextComponentAdapter textComponentAdapter;
    private DialogAdapter<?> dialogAdapter;
    private Set<ItemFlag> commonFlagsToHide;

    @Override
    public boolean initialize() {
        this.textComponentAdapter = new SpigotTextComponentAdapter(this);
        if (Version.isAtLeast(Version.MC_1_21_7)) {
            this.dialogAdapter = new SpigotDialogAdapter(this);
        }
        SpigotBridge.loadCommandMap();
        SpigotBridge.loadEntityCounter();
        if (Version.isAtLeast(Version.MC_1_21_5)) {
            this.commonFlagsToHide = Lists.newSet(ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_UNBREAKABLE, ItemFlag.HIDE_ENCHANTS, ItemFlag.HIDE_PLACED_ON, ItemFlag.HIDE_DESTROYS, ItemFlag.HIDE_DYE, ItemFlag.HIDE_ARMOR_TRIM, ItemFlag.HIDE_ADDITIONAL_TOOLTIP);
        }
        return true;
    }

    private static void loadCommandMap() {
        commandMap = (SimpleCommandMap)Reflex.getFieldValue(Bukkit.getServer(), FIELD_COMMAND_MAP);
    }

    private static void loadEntityCounter() {
        Class<?> entityClass = Reflex.getClass("net.minecraft.world.entity", "Entity");
        if (entityClass == null) {
            return;
        }
        Object object = Reflex.getFieldValue(entityClass, "c");
        if (!(object instanceof AtomicInteger)) {
            return;
        }
        AtomicInteger atomicInteger = (AtomicInteger)object;
        entityCounter = atomicInteger;
    }

    @Override
    @NotNull
    public Listener createDialogListener(@NotNull DialogClickHandler handler) {
        return new SpigotDialogListener(handler);
    }

    @Override
    public void closeDialog(@NotNull Player player) {
        player.clearDialog();
    }

    @Override
    public void showDialog(@NotNull Player player, @NotNull WrappedDialog dialog) {
        player.showDialog((Dialog)this.dialogAdapter.adaptDialog(dialog));
    }

    @Override
    @NotNull
    public String getName() {
        return "spigot-bridge";
    }

    @Override
    public boolean isPaper() {
        return false;
    }

    @Override
    public int nextEntityId() {
        return entityCounter.incrementAndGet();
    }

    @NotNull
    public SpigotTextComponentAdapter getTextComponentAdapter() {
        return this.textComponentAdapter;
    }

    @NotNull
    public DialogAdapter<?> getDialogAdapter() {
        return this.dialogAdapter;
    }

    @Override
    @NotNull
    public SimpleCommandMap getCommandMap() {
        if (commandMap == null) {
            throw new IllegalStateException("Command map is null!");
        }
        return commandMap;
    }

    @Override
    @NotNull
    public Map<String, Command> getKnownCommands(@NotNull SimpleCommandMap commandMap) {
        Map knownCommands = (Map)Reflex.getFieldValue(commandMap, FIELD_KNOWN_COMMANDS);
        return knownCommands == null ? Collections.emptyMap() : knownCommands;
    }

    @Override
    @NotNull
    public NightProfile createProfile(@NotNull UUID uuid) {
        return new SpigotProfile(Bukkit.createPlayerProfile((UUID)uuid));
    }

    @Override
    @NotNull
    public NightProfile createProfile(@NotNull String name) {
        return new SpigotProfile(Bukkit.createPlayerProfile((String)name));
    }

    @Override
    @NotNull
    public NightProfile createProfile(@Nullable UUID uuid, @Nullable String name) {
        return new SpigotProfile(Bukkit.createPlayerProfile((UUID)uuid, (String)name));
    }

    @Override
    @NotNull
    public NightProfile getProfile(@NotNull OfflinePlayer player) {
        return new SpigotProfile(player.getPlayerProfile());
    }

    @Override
    public void sendTitles(@NotNull Player player, @NotNull NightComponent title, @NotNull NightComponent subtitle, int fadeIn, int stay, int fadeOut) {
        player.sendTitle(title.toLegacy(), subtitle.toLegacy(), fadeIn, stay, fadeOut);
    }

    @Override
    @NotNull
    public InventoryView createView(@NotNull MenuType menuType, @NotNull NightComponent title, @NotNull Player player) {
        String legacy = title.toLegacy();
        if (Version.isAtLeast(Version.MC_1_21_4)) {
            InventoryViewBuilder builder = menuType.typed().builder();
            Reflex.setFieldValue(builder, "title", legacy);
            return builder.build((HumanEntity)player);
        }
        return menuType.typed().create((HumanEntity)player, legacy);
    }

    @Override
    @NotNull
    public String getTranslationKey(@NotNull Material material) {
        return SpigotBridge.getTranslation((Translatable)material);
    }

    @Override
    @NotNull
    public String getTranslationKey(@NotNull Attribute attribute) {
        return SpigotBridge.getTranslation((Translatable)attribute);
    }

    @Override
    @NotNull
    public String getTranslationKey(@NotNull EntityType entityType) {
        return SpigotBridge.getTranslation((Translatable)entityType);
    }

    @Override
    @NotNull
    public String getTranslationKey(@NotNull Enchantment enchantment) {
        return SpigotBridge.getTranslation((Translatable)enchantment);
    }

    @Override
    @NotNull
    public String getTranslationKey(@NotNull PotionEffectType effectType) {
        return SpigotBridge.getTranslation((Translatable)effectType);
    }

    @NotNull
    public static String getTranslation(@NotNull Translatable translatable) {
        return translatable.getTranslationKey();
    }

    @Override
    @NotNull
    public String getDisplayNameSerialized(@NotNull Player player) {
        return LegacyColors.plainColors(player.getDisplayName());
    }

    @Override
    public void setDisplayName(@NotNull Player player, @NotNull NightComponent component) {
        player.setDisplayName(component.toLegacy());
    }

    @Override
    public void setCustomName(@NotNull Entity entity, @NotNull NightComponent component) {
        entity.setCustomName(component.toLegacy());
    }

    @Override
    @Nullable
    public String getEntityName(@NotNull Entity entity) {
        String name = entity.getCustomName();
        return name == null ? null : LegacyColors.plainColors(name);
    }

    @Override
    @NotNull
    public ItemStack setType(@NotNull ItemStack itemStack, @NotNull Material material) {
        itemStack.setType(material);
        return itemStack;
    }

    @Override
    public void editMeta(@NotNull ItemStack item, @NotNull Consumer<ItemMeta> consumer) {
        SpigotBridge.editItemMeta(item, ItemMeta.class, consumer);
    }

    @Override
    public <T extends ItemMeta> void editMeta(@NotNull ItemStack item, @NotNull Class<T> clazz, @NotNull Consumer<T> consumer) {
        SpigotBridge.editItemMeta(item, clazz, consumer);
    }

    @Override
    @Nullable
    public String getCustomName(@NotNull ItemMeta meta) {
        return meta.hasDisplayName() ? LegacyColors.plainColors(meta.getDisplayName()) : null;
    }

    @Override
    public void setCustomName(@NotNull ItemMeta meta, @Nullable NightComponent name) {
        meta.setDisplayName(name == null ? null : name.toLegacy());
    }

    @Override
    @Nullable
    public String getItemName(@NotNull ItemMeta meta) {
        return meta.hasItemName() ? LegacyColors.plainColors(meta.getItemName()) : null;
    }

    @Override
    public void setItemName(@NotNull ItemMeta meta, @NotNull NightComponent name) {
        meta.setItemName(name.toLegacy());
    }

    @Override
    @Nullable
    public List<String> getLore(@NotNull ItemMeta meta) {
        List lore = meta.getLore();
        return lore == null ? null : Lists.modify(lore, LegacyColors::plainColors);
    }

    @Override
    public void setLore(@NotNull ItemMeta meta, @Nullable List<NightComponent> lore) {
        meta.setLore(lore == null ? null : lore.stream().map(NightComponent::toLegacy).toList());
    }

    @Override
    @Nullable
    public NightProfile getOwnerProfile(@NotNull ItemStack itemStack) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (!(itemMeta instanceof SkullMeta)) {
            return null;
        }
        SkullMeta meta = (SkullMeta)itemMeta;
        PlayerProfile profile = meta.getOwnerProfile();
        return profile == null ? null : new SpigotProfile(profile);
    }

    @Override
    @NotNull
    public Set<String> getCommonComponentsToHide() {
        if (this.commonFlagsToHide == null) {
            return new HashSet<String>();
        }
        return this.commonFlagsToHide.stream().map(Enum::name).map(String::toLowerCase).collect(Collectors.toSet());
    }

    @Override
    @NotNull
    public Set<String> getHiddenComponents(@NotNull ItemStack itemStack) {
        ItemMeta meta;
        ItemMeta itemMeta = meta = itemStack.hasItemMeta() ? itemStack.getItemMeta() : null;
        if (meta == null) {
            return Collections.emptySet();
        }
        return meta.getItemFlags().stream().map(Enum::name).map(String::toLowerCase).collect(Collectors.toSet());
    }

    @Override
    public void hideComponents(@NotNull ItemStack itemStack) {
        if (this.commonFlagsToHide == null) {
            return;
        }
        SpigotBridge.hideSpigotComponents(itemStack, this.commonFlagsToHide);
    }

    @Override
    public void hideComponents(@NotNull ItemStack itemStack, @NotNull Set<String> componentNames) {
        SpigotBridge.hideComponentsByName(itemStack, componentNames);
    }

    public static void hideComponentsByName(@NotNull ItemStack itemStack, @NotNull Set<String> componentNames) {
        Set<ItemFlag> componentTypes = componentNames.stream().map(name -> Enums.parse(name, ItemFlag.class).orElse(null)).filter(Objects::nonNull).collect(Collectors.toSet());
        SpigotBridge.hideSpigotComponents(itemStack, componentTypes);
    }

    public static void hideSpigotComponents(@NotNull ItemStack itemStack, @NotNull Set<ItemFlag> componentTypes) {
        SpigotBridge.editItemMeta(itemStack, meta -> componentTypes.forEach(xva$0 -> meta.addItemFlags(new ItemFlag[]{xva$0})));
    }

    private static void editItemMeta(@NotNull ItemStack item, @NotNull Consumer<ItemMeta> consumer) {
        SpigotBridge.editItemMeta(item, ItemMeta.class, consumer);
    }

    private static <T extends ItemMeta> void editItemMeta(@NotNull ItemStack item, @NotNull Class<T> clazz, @NotNull Consumer<T> consumer) {
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return;
        }
        if (!clazz.isAssignableFrom(meta.getClass())) {
            return;
        }
        ItemMeta specific = (ItemMeta)clazz.cast(meta);
        consumer.accept(specific);
        item.setItemMeta(specific);
    }

    @Override
    @NotNull
    public SpigotBossBar createBossBar(@NotNull NightComponent title, @NotNull NightBarColor barColor, @NotNull NightBarOverlay barOverlay, NightBarFlag ... barFlags) {
        BarColor color = SpigotBossBarAdapter.adaptColor(barColor);
        BarStyle overlay = SpigotBossBarAdapter.adaptOverlay(barOverlay);
        BossBar bar = Bukkit.createBossBar((String)title.toLegacy(), (BarColor)color, (BarStyle)overlay, (BarFlag[])new BarFlag[0]);
        return new SpigotBossBar(bar).addFlags(barFlags);
    }
}

