/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.nightcore.bridge.paper.bossbar;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.bossbar.BossBar;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.UnmodifiableView;
import su.nightexpress.nightcore.bridge.bossbar.NightBarColor;
import su.nightexpress.nightcore.bridge.bossbar.NightBarFlag;
import su.nightexpress.nightcore.bridge.bossbar.NightBarOverlay;
import su.nightexpress.nightcore.bridge.bossbar.NightBossBar;
import su.nightexpress.nightcore.bridge.paper.PaperBridge;
import su.nightexpress.nightcore.bridge.paper.bossbar.PaperBossBarAdapter;
import su.nightexpress.nightcore.util.Lists;
import su.nightexpress.nightcore.util.bridge.wrapper.NightComponent;

public class PaperBossBar
implements NightBossBar {
    private final PaperBridge bridge;
    private final BossBar backend;

    public PaperBossBar(@NotNull PaperBridge bridge, @NotNull BossBar backend) {
        this.bridge = bridge;
        this.backend = backend;
    }

    @Override
    @NotNull
    public PaperBossBar setName(@NotNull NightComponent name) {
        this.backend.name(this.bridge.getTextComponentAdapter().adaptComponent(name));
        return this;
    }

    @Override
    public float getProgress() {
        return this.backend.progress();
    }

    @Override
    @NotNull
    public PaperBossBar setProgress(float progress) {
        this.backend.progress(Math.clamp(progress, 0.0f, 1.0f));
        return this;
    }

    @Override
    @NotNull
    public NightBarColor getColor() {
        return PaperBossBarAdapter.wrapColor(this.backend.color());
    }

    @Override
    @NotNull
    public PaperBossBar setColor(@NotNull NightBarColor color) {
        this.backend.color(PaperBossBarAdapter.adaptColor(color));
        return this;
    }

    @Override
    @NotNull
    public NightBarOverlay getOverlay() {
        return PaperBossBarAdapter.wrapOverlay(this.backend.overlay());
    }

    @Override
    @NotNull
    public PaperBossBar setOverlay(@NotNull NightBarOverlay overlay) {
        this.backend.overlay(PaperBossBarAdapter.adaptOverlay(overlay));
        return this;
    }

    @Override
    public @UnmodifiableView @NotNull Set<NightBarFlag> getFlags() {
        return this.backend.flags().stream().map(PaperBossBarAdapter::wrapFlag).collect(Collectors.toSet());
    }

    @Override
    @NotNull
    public PaperBossBar setFlags(@NotNull Set<NightBarFlag> flags) {
        this.backend.flags(Lists.modify(flags, PaperBossBarAdapter::adaptFlag));
        return this;
    }

    @Override
    public boolean hasFlag(@NotNull NightBarFlag flag) {
        return this.backend.hasFlag(PaperBossBarAdapter.adaptFlag(flag));
    }

    @Override
    @NotNull
    public PaperBossBar addFlag(@NotNull NightBarFlag flag) {
        this.backend.addFlag(PaperBossBarAdapter.adaptFlag(flag));
        return this;
    }

    @Override
    @NotNull
    public PaperBossBar addFlags(NightBarFlag ... flags) {
        for (NightBarFlag barFlag : flags) {
            this.addFlag(barFlag);
        }
        return this;
    }

    @Override
    @NotNull
    public PaperBossBar removeFlag(@NotNull NightBarFlag flag) {
        this.backend.removeFlag(PaperBossBarAdapter.adaptFlag(flag));
        return this;
    }

    @Override
    public @UnmodifiableView @NotNull Set<Player> getViewers() {
        HashSet<Player> players = new HashSet<Player>();
        this.backend.viewers().forEach(viewer -> {
            if (viewer instanceof Player) {
                Player player = (Player)viewer;
                players.add(player);
            }
        });
        return players;
    }

    @Override
    @NotNull
    public PaperBossBar addViewer(@NotNull Player viewer) {
        this.backend.addViewer((Audience)viewer);
        return this;
    }

    @Override
    @NotNull
    public PaperBossBar removeViewer(@NotNull Player viewer) {
        this.backend.removeViewer((Audience)viewer);
        return this;
    }

    @Override
    @NotNull
    public PaperBossBar removeViewers() {
        this.getViewers().forEach(this::removeViewer);
        return this;
    }
}

