/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.nightcore.util.text.night;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.nightcore.util.text.night.tag.TagContent;
import su.nightexpress.nightcore.util.text.night.tag.TagHandler;
import su.nightexpress.nightcore.util.text.night.tag.TagHandlerRegistry;
import su.nightexpress.nightcore.util.text.night.tag.handler.NamedColorTagHandler;
import su.nightexpress.nightcore.util.text.night.wrapper.SimpleTagWrapper;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;

public class ParserUtils {
    public static final char ESCAPE = '\\';
    public static final char OPEN_BRACKET = '<';
    public static final char CLOSE_BRACKET = '>';
    public static final char CLOSE_SLASH = '/';
    public static final char DELIMITER = ':';
    public static final char QUOTE = '\'';
    public static final char DOUBLE_QUOTE = '\"';
    private static final String[] LINE_SPLITTERS = new String[]{TagWrappers.BR, TagWrappers.NEWLINE};

    public static String[] breakDownLineSplitters(@NotNull String string) {
        for (String alias : LINE_SPLITTERS) {
            string = string.replace(alias, "\n");
        }
        return string.split("\n");
    }

    @NotNull
    public static List<String> breakDownLineSplitters(@NotNull List<String> list) {
        ArrayList<String> segmented = new ArrayList<String>();
        list.forEach(line -> Collections.addAll(segmented, ParserUtils.breakDownLineSplitters(line)));
        return segmented;
    }

    public static int findUnescapedUnquotedChar(String input, char target, int fromIndex) {
        return ParserUtils.findUnescapedUnquotedUnprecededByChar(input, target, null, fromIndex);
    }

    public static int findUnescapedUnquotedUnprecededByChar(String input, char target, @Nullable Character precede, int fromIndex) {
        if (fromIndex >= input.length()) {
            return -1;
        }
        boolean inSingleQuotes = false;
        boolean inDoubleQuotes = false;
        boolean escaped = false;
        boolean preceded = false;
        for (int index = fromIndex; index < input.length(); ++index) {
            char letter = input.charAt(index);
            if (escaped) {
                escaped = false;
                continue;
            }
            if (letter == '\\') {
                escaped = true;
                continue;
            }
            if (precede != null && letter == precede.charValue()) {
                preceded = true;
                continue;
            }
            if (!inDoubleQuotes && letter == '\'') {
                inSingleQuotes = !inSingleQuotes;
                continue;
            }
            if (!inSingleQuotes && letter == '\"') {
                inDoubleQuotes = !inDoubleQuotes;
                continue;
            }
            if (inSingleQuotes || inDoubleQuotes || letter != target) continue;
            if (preceded) {
                preceded = false;
                continue;
            }
            return index;
        }
        return -1;
    }

    @NotNull
    public static TagContent parseInnerContent(@NotNull String tagContent) {
        String first;
        int index = ParserUtils.findUnescapedUnquotedChar(tagContent, ':', 0);
        String string = first = index < 0 ? tagContent : ParserUtils.unquoted(tagContent.substring(0, index));
        String second = index < 0 ? null : (index >= tagContent.length() ? null : ParserUtils.unquoted(tagContent.substring(index + 1)));
        return new TagContent(first, second);
    }

    @Nullable
    public static Color colorFromSchemeOrHex(@NotNull String string) {
        if (string.startsWith("#") && string.length() == 7) {
            return ParserUtils.colorFromHexString(string);
        }
        return ParserUtils.findColorFromScheme(string);
    }

    @Nullable
    public static Color findColorFromScheme(@NotNull String name) {
        TagHandler handler = TagHandlerRegistry.create(name);
        if (handler instanceof NamedColorTagHandler) {
            NamedColorTagHandler colorHandler = (NamedColorTagHandler)handler;
            return colorHandler.getColor();
        }
        return null;
    }

    @NotNull
    public static Color colorFromHexString(@NotNull String string) {
        return ParserUtils.colorFromHexString(string, Color.WHITE);
    }

    @NotNull
    public static Color colorFromHexString(@NotNull String string, @NotNull Color fallback) {
        if (((String)string).charAt(0) != '#') {
            string = "#" + (String)string;
        }
        try {
            return Color.decode((String)string);
        }
        catch (NumberFormatException exception) {
            exception.printStackTrace();
            return fallback;
        }
    }

    @NotNull
    public static String colorToHexString(@NotNull Color color) {
        return "#" + Integer.toHexString(color.getRGB()).substring(2);
    }

    @NotNull
    public static String quoted(@NotNull String content) {
        return "\"" + ParserUtils.escapeQuotes(content) + "\"";
    }

    @NotNull
    public static String unquoted(@NotNull String str) {
        String dQuote = String.valueOf('\"');
        String sQuote = String.valueOf('\'');
        if (str.startsWith(dQuote) || str.startsWith(sQuote)) {
            str = str.substring(1);
        }
        if (str.endsWith(dQuote) || str.endsWith(sQuote)) {
            str = str.substring(0, str.length() - 1);
        }
        return str.replace("\\", "");
    }

    @NotNull
    public static String escapeQuotes(@NotNull String content) {
        return content.replace(String.valueOf('\''), "\\'").replace(String.valueOf('\"'), "\\\"");
    }

    @Nullable
    public static SimpleTagWrapper legacyToNamedWrapper(char colorChar) {
        return switch (colorChar) {
            case '0' -> TagWrappers.BLACK;
            case '1' -> TagWrappers.DARK_BLUE;
            case '2' -> TagWrappers.DARK_GREEN;
            case '3' -> TagWrappers.DARK_AQUA;
            case '4' -> TagWrappers.DARK_RED;
            case '5' -> TagWrappers.DARK_PURPLE;
            case '6' -> TagWrappers.GOLD;
            case '7' -> TagWrappers.GRAY;
            case '8' -> TagWrappers.DARK_GRAY;
            case '9' -> TagWrappers.BLUE;
            case 'a' -> TagWrappers.GREEN;
            case 'b' -> TagWrappers.AQUA;
            case 'c' -> TagWrappers.RED;
            case 'd' -> TagWrappers.LIGHT_PURPLE;
            case 'e' -> TagWrappers.YELLOW;
            case 'f' -> TagWrappers.WHITE;
            case 'k' -> TagWrappers.OBFUSCATED;
            case 'l' -> TagWrappers.BOLD;
            case 'm' -> TagWrappers.STRIKETHROUGH;
            case 'n' -> TagWrappers.UNDERLINED;
            case 'o' -> TagWrappers.ITALIC;
            case 'r' -> TagWrappers.RESET;
            default -> null;
        };
    }

    @NotNull
    public static String wrapHexCodesAsTags(@NotNull String str) {
        int index;
        StringBuilder builder = new StringBuilder(str);
        int lastIndex = 0;
        while ((index = builder.toString().indexOf("#", lastIndex)) >= 0) {
            Character postfix;
            lastIndex = index + 1;
            int lookup = index + 7;
            if (builder.length() < lookup) break;
            Character prefix = index > 0 ? Character.valueOf(builder.charAt(index - 1)) : null;
            Character c = postfix = builder.length() > lookup ? Character.valueOf(builder.charAt(lookup)) : null;
            if (prefix != null && prefix.charValue() == '<' || postfix != null && postfix.charValue() == '>' || prefix != null && postfix != null && prefix.charValue() == ':' && postfix.charValue() == ':') continue;
            String sub = builder.substring(index, lookup);
            try {
                Integer.decode(sub);
            }
            catch (NumberFormatException exception) {
                continue;
            }
            builder.insert(index, '<');
            builder.insert(index + 8, '>');
        }
        return builder.toString();
    }
}

