/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.nightcore.util.placeholder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.util.StringUtil;
import su.nightexpress.nightcore.util.placeholder.PlaceholderEntry;

public class PlaceholderList<T> {
    private final Map<String, PlaceholderEntry<T>> entries;

    public PlaceholderList() {
        this(new ArrayList<PlaceholderEntry<T>>());
    }

    public PlaceholderList(@NotNull PlaceholderList<T> other) {
        this(other.getEntries());
    }

    public PlaceholderList(@NotNull List<PlaceholderEntry<T>> entries) {
        this(PlaceholderList.fromList(entries));
    }

    public PlaceholderList(@NotNull Map<String, PlaceholderEntry<T>> entries) {
        this.entries = new LinkedHashMap<String, PlaceholderEntry<T>>(entries);
    }

    @NotNull
    public static <T> PlaceholderList<T> create(@NotNull Consumer<PlaceholderList<T>> consumer) {
        PlaceholderList<T> placeholderList = new PlaceholderList<T>();
        consumer.accept(placeholderList);
        return placeholderList;
    }

    @NotNull
    private static <T> Map<String, PlaceholderEntry<T>> fromList(@NotNull List<PlaceholderEntry<T>> entries) {
        HashMap map = new HashMap();
        entries.forEach(entry -> map.put(entry.getKey().toLowerCase(), (PlaceholderEntry)entry));
        return map;
    }

    @NotNull
    public List<PlaceholderEntry<T>> getEntries() {
        return new ArrayList<PlaceholderEntry<T>>(this.entries.values());
    }

    @NotNull
    public PlaceholderList<T> add(@NotNull PlaceholderList<? super T> other) {
        other.getEntries().forEach(entry -> this.add(entry.getKey(), entry::get));
        return this;
    }

    @NotNull
    public PlaceholderList<T> add(@NotNull String key, @NotNull String replacer) {
        this.add(key, (T source) -> replacer);
        return this;
    }

    @NotNull
    public PlaceholderList<T> add(@NotNull String key, @NotNull Supplier<String> replacer) {
        this.add(key, (T source) -> (String)replacer.get());
        return this;
    }

    @NotNull
    public PlaceholderList<T> add(@NotNull String key, @NotNull Function<T, String> replacer) {
        this.entries.put(key.toLowerCase(), new PlaceholderEntry<T>(key, replacer));
        return this;
    }

    public boolean remove(@NotNull String key) {
        return this.entries.remove(key.toLowerCase()) != null;
    }

    public void clear() {
        this.entries.clear();
    }

    @NotNull
    public UnaryOperator<String> replacer(@NotNull T source) {
        return str -> StringUtil.replaceEach(str, this.getEntries(), source);
    }

    @NotNull
    public String apply(@NotNull String str, @NotNull T source) {
        return (String)this.replacer(source).apply(str);
    }
}

