/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.nightcore.util.bridge.wrapper;

import java.awt.Color;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.nightcore.bridge.common.NightKey;
import su.nightexpress.nightcore.bridge.text.NightStyle;
import su.nightexpress.nightcore.bridge.text.NightTextDecoration;
import su.nightexpress.nightcore.bridge.text.adapter.TextComponentAdapter;
import su.nightexpress.nightcore.bridge.text.contents.NightObjectContents;
import su.nightexpress.nightcore.bridge.text.event.NightClickEvent;
import su.nightexpress.nightcore.bridge.text.event.NightHoverEvent;
import su.nightexpress.nightcore.bridge.text.impl.NightKeybindComponent;
import su.nightexpress.nightcore.bridge.text.impl.NightObjectComponent;
import su.nightexpress.nightcore.bridge.text.impl.NightTextComponent;
import su.nightexpress.nightcore.bridge.text.impl.NightTranslatableComponent;
import su.nightexpress.nightcore.bridge.text.impl.NightTranslationArgument;

public interface NightComponent {
    @NotNull
    public static NightTextComponent empty() {
        return NightTextComponent.EMPTY;
    }

    @NotNull
    public static NightTextComponent newline() {
        return NightTextComponent.NEWLINE;
    }

    @NotNull
    public static NightTextComponent space() {
        return NightTextComponent.SPACE;
    }

    @NotNull
    public static NightKeybindComponent keybind(@NotNull String keybind) {
        return NightComponent.keybind(keybind, NightStyle.EMPTY);
    }

    @NotNull
    public static NightKeybindComponent keybind(@NotNull String keybind, @NotNull NightStyle style) {
        return NightKeybindComponent.create(keybind, style);
    }

    @NotNull
    public static NightObjectComponent object(@NotNull NightStyle style, @NotNull NightObjectContents contents) {
        return NightObjectComponent.create(style, contents);
    }

    @NotNull
    public static NightTextComponent text(@NotNull String content, @NotNull NightStyle style) {
        return content.isEmpty() ? NightComponent.empty() : NightTextComponent.create(content, style);
    }

    @NotNull
    public static NightTextComponent text(@NotNull String content) {
        return NightComponent.text(content, NightStyle.EMPTY);
    }

    @NotNull
    public static NightTextComponent text(boolean value) {
        return NightComponent.text(String.valueOf(value));
    }

    @NotNull
    public static NightTextComponent text(char value) {
        if (value == '\n') {
            return NightComponent.newline();
        }
        if (value == ' ') {
            return NightComponent.space();
        }
        return NightComponent.text(String.valueOf(value));
    }

    @NotNull
    public static NightTextComponent text(double value) {
        return NightComponent.text(String.valueOf(value));
    }

    @NotNull
    public static NightTextComponent text(float value) {
        return NightComponent.text(String.valueOf(value));
    }

    @NotNull
    public static NightTextComponent text(int value) {
        return NightComponent.text(String.valueOf(value));
    }

    @NotNull
    public static NightTextComponent text(long value) {
        return NightComponent.text(String.valueOf(value));
    }

    @NotNull
    public static NightTranslatableComponent translatable(@NotNull String key) {
        return NightComponent.translatable(key, null);
    }

    @NotNull
    public static NightTranslatableComponent translatable(@NotNull String key, @Nullable String fallback) {
        return NightComponent.translatable(key, fallback, NightStyle.EMPTY);
    }

    @NotNull
    public static NightTranslatableComponent translatable(@NotNull String key, @Nullable String fallback, @NotNull NightStyle style) {
        return NightComponent.translatable(key, fallback, Collections.emptyList(), style);
    }

    @NotNull
    public static NightTranslatableComponent translatable(@NotNull String key, @Nullable String fallback, @NotNull List<NightTranslationArgument> args, @NotNull NightStyle style) {
        return NightTranslatableComponent.create(key, fallback, args, style);
    }

    @NotNull
    public <T> T adapt(@NotNull TextComponentAdapter<T> var1);

    @NotNull
    public String toJson();

    @NotNull
    public String toLegacy();

    public void send(@NotNull CommandSender var1);

    public void sendActionBar(@NotNull Player var1);

    public boolean isEmpty();

    public boolean hasStyling();

    @NotNull
    public NightComponent appendNewline();

    @NotNull
    public NightComponent appendSpace();

    @NotNull
    public NightComponent append(@NotNull NightComponent var1);

    @NotNull
    public NightComponent append(NightComponent ... var1);

    @NotNull
    public NightComponent append(@NotNull List<? extends NightComponent> var1);

    @NotNull
    public List<NightComponent> children();

    @NotNull
    public NightComponent children(@NotNull List<? extends NightComponent> var1);

    @NotNull
    public NightStyle style();

    @NotNull
    public NightComponent style(@NotNull NightStyle var1);

    @Nullable
    public NightKey font();

    @NotNull
    public NightComponent font(@Nullable NightKey var1);

    @Nullable
    public Color color();

    @Nullable
    public Color shadowColor();

    @NotNull
    public NightComponent color(@Nullable Color var1);

    @NotNull
    public NightComponent shadowColor(@Nullable Color var1);

    public boolean hasDecoration(@NotNull NightTextDecoration var1);

    @NotNull
    public NightComponent decorate(@NotNull NightTextDecoration var1);

    @NotNull
    public NightTextDecoration.State decoration(@NotNull NightTextDecoration var1);

    @NotNull
    public NightComponent decoration(@NotNull NightTextDecoration var1, boolean var2);

    @NotNull
    public NightComponent decoration(@NotNull NightTextDecoration var1, @NotNull NightTextDecoration.State var2);

    @NotNull
    public Map<NightTextDecoration, NightTextDecoration.State> decorations();

    @Nullable
    public NightClickEvent clickEvent();

    @NotNull
    public NightComponent clickEvent(@Nullable NightClickEvent var1);

    @Nullable
    public NightHoverEvent<?> hoverEvent();

    @NotNull
    public NightComponent hoverEvent(@Nullable NightHoverEvent<?> var1);

    @Nullable
    public String insertion();

    @NotNull
    public NightComponent insertion(@Nullable String var1);
}

