/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.nightcore.util;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.nightcore.config.ConfigValue;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.util.Enums;
import su.nightexpress.nightcore.util.Players;

@Deprecated
public class RankMap<T extends Number> {
    private final Mode mode;
    private final String permissionPrefix;
    private final T defaultValue;
    private final Map<String, T> values;

    public RankMap(@NotNull Mode mode, @NotNull String permissionPrefix, @NotNull T defaultValue, @NotNull Map<String, T> values) {
        this.mode = mode;
        this.permissionPrefix = permissionPrefix;
        this.defaultValue = defaultValue;
        this.values = new HashMap<String, T>(values);
    }

    @NotNull
    public static RankMap<Integer> readInt(@NotNull FileConfig cfg, @NotNull String path, int defaultValue) {
        return RankMap.read(cfg, path, Integer.class, defaultValue);
    }

    @NotNull
    public static RankMap<Double> readDouble(@NotNull FileConfig cfg, @NotNull String path, double defaultValue) {
        return RankMap.read(cfg, path, Double.class, defaultValue);
    }

    @NotNull
    public static RankMap<Long> readLong(@NotNull FileConfig cfg, @NotNull String path, long defaultValue) {
        return RankMap.read(cfg, path, Long.class, defaultValue);
    }

    @NotNull
    public static <T extends Number> RankMap<T> read(@NotNull FileConfig config, @NotNull String path, @NotNull Class<T> clazz, @NotNull T defaultValue) {
        HashMap<String, Number> oldMap = new HashMap<String, Number>();
        if (!config.contains(path + ".Mode")) {
            for (String rank2 : config.getSection(path)) {
                Number number2 = clazz == Double.class ? (Number)((Number)clazz.cast(config.getDouble(path + "." + rank2))) : (Number)((Number)clazz.cast(config.getInt(path + "." + rank2)));
                oldMap.put(rank2.toLowerCase(), number2);
            }
            config.remove(path);
        }
        oldMap.forEach((rank, number) -> {
            if (rank.equalsIgnoreCase("default")) {
                config.set(path + ".Default_Value", number);
            } else {
                config.set(path + ".Values." + rank, number);
            }
        });
        Mode mode = ConfigValue.create(path + ".Mode", Mode.class, Mode.RANK, "Available values: " + Enums.inline(Mode.class), "=".repeat(20) + " " + Mode.RANK.name() + " MODE " + "=".repeat(20), "Get value by player's permission group. All keys in 'Values' list will represent permission group names.", "If player has none of specified groups, the 'Default_Value' setting will be used then", "  Values:", "    vip: 1 # -> Player must be in 'vip' permission group.", "    gold: 2 # -> Player must be in 'gold' permission group.", "    emerald: 3 # -> Player must be in 'emerald' permission group.", "", "=".repeat(20) + " " + Mode.PERMISSION.name() + " MODE " + "=".repeat(20), "Get value by player's permissions. All keys in 'Values' list will represent postfixes for the 'Permission_Prefix' setting (see below).", "If player has none of specified permissions, the 'Default_Value' setting will be used then", "  Permission_Prefix: 'example.prefix.'", "  Values:", "    vip: 1 # -> Player must have 'example.prefix.vip' permission.", "    gold: 2 # -> Player must have 'example.prefix.gold' permission.", "    emerald: 3 # -> Player must have 'example.prefix.emerald' permission.").read(config);
        String permissionPrefix = ConfigValue.create(path + ".Permission_Prefix", "example.prefix.", "Sets permission prefix for the '" + Mode.PERMISSION.name() + "' mode.").read(config);
        Number fallback = clazz == Double.class ? (Number)((Number)clazz.cast(ConfigValue.create(path + ".Default_Value", defaultValue.doubleValue(), new String[0]).read(config))) : (Number)((Number)clazz.cast(ConfigValue.create(path + ".Default_Value", defaultValue.intValue(), new String[0]).read(config)));
        HashMap<String, Number> values = new HashMap<String, Number>();
        for (String rank3 : config.getSection(path + ".Values")) {
            Number number3 = clazz == Double.class ? (Number)((Number)clazz.cast(config.getDouble(path + ".Values." + rank3))) : (Number)((Number)clazz.cast(config.getInt(path + ".Values." + rank3)));
            values.put(rank3.toLowerCase(), number3);
        }
        return new RankMap<Number>(mode, permissionPrefix, fallback, values);
    }

    public void write(@NotNull FileConfig config, @NotNull String path) {
        config.set(path + ".Mode", this.mode.name());
        config.set(path + ".Permission_Prefix", this.permissionPrefix);
        config.set(path + ".Default_Value", this.defaultValue);
        this.values.forEach((rank, number) -> config.set(path + ".Values." + rank, number));
    }

    @NotNull
    public T getRankValue(@NotNull Player player) {
        String group = Players.getPermissionGroup(player);
        return (T)((Number)this.values.getOrDefault(group, this.defaultValue));
    }

    @NotNull
    public T getGreatestOrNegative(@NotNull Player player) {
        T best = this.getGreatest(player);
        T lowest = this.getSmallest(player);
        return ((Number)lowest).doubleValue() < 0.0 ? lowest : best;
    }

    @NotNull
    public T getGreatest(@NotNull Player player) {
        if (this.mode == Mode.RANK) {
            return this.getRankValue(player);
        }
        return (T)this.values.entrySet().stream().filter(entry -> player.hasPermission(this.permissionPrefix + (String)entry.getKey())).map(Map.Entry::getValue).max(Comparator.comparingDouble(Number::doubleValue)).orElse((Number)this.defaultValue);
    }

    @NotNull
    public T getSmallest(@NotNull Player player) {
        if (this.mode == Mode.RANK) {
            return this.getRankValue(player);
        }
        return (T)this.values.entrySet().stream().filter(entry -> player.hasPermission(this.permissionPrefix + (String)entry.getKey())).map(Map.Entry::getValue).min(Comparator.comparingDouble(Number::doubleValue)).orElse((Number)this.defaultValue);
    }

    @NotNull
    public Mode getMode() {
        return this.mode;
    }

    @Nullable
    public String getPermissionPrefix() {
        return this.permissionPrefix;
    }

    @NotNull
    public T getDefaultValue() {
        return this.defaultValue;
    }

    public static enum Mode {
        RANK,
        PERMISSION;

    }
}

