/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.nightcore.ui.inventory.condition;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.nightcore.ui.inventory.condition.ItemStateCondition;
import su.nightexpress.nightcore.util.LowerCase;

public class ConditionRegistry {
    private final Map<String, ItemStateCondition> conditionMap = new HashMap<String, ItemStateCondition>();

    public void register(@NotNull String name, @NotNull ItemStateCondition condition) {
        String id = LowerCase.INTERNAL.apply(name);
        if (this.conditionMap.containsKey(id)) {
            return;
        }
        this.conditionMap.put(id, condition);
    }

    @Nullable
    public ItemStateCondition getById(@NotNull String id) {
        return this.conditionMap.get(LowerCase.INTERNAL.apply(id));
    }

    @NotNull
    public Optional<ItemStateCondition> byId(@NotNull String id) {
        return Optional.ofNullable(this.getById(id));
    }
}

