/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.nightcore.util.text;

import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.nightcore.core.CoreConfig;
import su.nightexpress.nightcore.util.LegacyColors;
import su.nightexpress.nightcore.util.bridge.wrapper.NightComponent;
import su.nightexpress.nightcore.util.text.TextGroup;
import su.nightexpress.nightcore.util.text.TextNode;
import su.nightexpress.nightcore.util.text.night.ParserUtils;
import su.nightexpress.nightcore.util.text.tag.TagPool;
import su.nightexpress.nightcore.util.text.tag.TagUtils;
import su.nightexpress.nightcore.util.text.tag.Tags;
import su.nightexpress.nightcore.util.text.tag.api.ContentTag;
import su.nightexpress.nightcore.util.text.tag.api.PlaceholderTag;
import su.nightexpress.nightcore.util.text.tag.api.Tag;
import su.nightexpress.nightcore.util.text.tag.decorator.Decorator;
import su.nightexpress.nightcore.util.text.tag.impl.ResetTag;
import su.nightexpress.nightcore.util.text.tag.impl.TranslationTag;

@Deprecated
public class TextRoot {
    public static final String ROOT_NAME = "root";
    private final TagPool tagPool;
    private String string;
    private TextGroup rootGroup;
    private TextGroup currentGroup;
    private TextNode currentNode;
    private NightComponent component;

    public TextRoot(@NotNull String string, @NotNull TagPool tagPool) {
        this.tagPool = tagPool;
        this.setString(string);
    }

    public void setString(@NotNull String string) {
        if (CoreConfig.LEGACY_COLOR_SUPPORT.get().booleanValue()) {
            string = LegacyColors.plainColors(string);
            string = ParserUtils.wrapHexCodesAsTags(string);
            string = TagUtils.replaceLegacyColors(string);
        }
        this.string = string;
        this.component = null;
    }

    @NotNull
    public TextRoot copy() {
        return new TextRoot(this.string, this.tagPool);
    }

    @NotNull
    public TextRoot compile() {
        this.parseIfAbsent();
        return this;
    }

    @NotNull
    public TextRoot recompile() {
        this.parse();
        return this;
    }

    @NotNull
    public String toLegacy() {
        this.parseIfAbsent();
        if (this.string.isBlank() || this.component.isEmpty()) {
            return "";
        }
        return this.component.toLegacy();
    }

    @NotNull
    public String toJson() {
        return this.parseIfAbsent().toJson();
    }

    @Deprecated
    @NotNull
    public NightComponent toComponent() {
        return this.parseIfAbsent();
    }

    @Deprecated
    @NotNull
    public TextRoot replace(@NotNull String what, @NotNull Object object) {
        return this.replace(str -> str.replace(what, String.valueOf(object)));
    }

    @NotNull
    public TextRoot replace(@NotNull UnaryOperator<String> operator) {
        this.setString((String)operator.apply(this.string));
        return this;
    }

    public void send(CommandSender ... senders) {
        this.parseIfAbsent();
        for (CommandSender sender : senders) {
            this.component.send(sender);
        }
    }

    @NotNull
    public TextGroup toParentGroup() {
        this.currentGroup = this.currentGroup.getParent();
        if (this.currentGroup == null) {
            this.currentGroup = this.rootGroup;
        }
        return this.currentGroup;
    }

    @NotNull
    public TextGroup toParentGroup(@NotNull String name) {
        TextGroup lastGroup = this.currentGroup;
        while (this.currentGroup != null && !this.currentGroup.getName().equalsIgnoreCase(name)) {
            this.currentGroup = this.currentGroup.getParent();
        }
        if (this.currentGroup == null && lastGroup != null) {
            this.currentGroup = lastGroup;
            return this.currentGroup;
        }
        if (this.currentGroup != null) {
            this.currentGroup = this.currentGroup.getParent();
        }
        if (this.currentGroup == null) {
            this.currentGroup = this.rootGroup;
        }
        return this.currentGroup;
    }

    @NotNull
    public TextNode currentNode() {
        if (this.currentNode == null) {
            this.currentNode = this.currentGroup.createNode();
        }
        return this.currentNode;
    }

    public NightComponent parseIfAbsent() {
        return this.component == null ? this.parse() : this.component;
    }

    @NotNull
    public NightComponent parse() {
        this.currentGroup = this.rootGroup = new TextGroup(ROOT_NAME);
        this.doJob(Mode.PARSE, letter -> this.currentNode().append(letter.charValue()));
        this.component = this.rootGroup.toComponent();
        this.rootGroup = null;
        this.currentGroup = null;
        this.currentNode = null;
        return this.component;
    }

    @NotNull
    public String strip() {
        StringBuilder builder = new StringBuilder();
        this.doJob(Mode.STRIP, builder::append);
        return builder.toString();
    }

    private void doJob(@NotNull Mode mode, @NotNull Consumer<Character> consumer) {
        int length = this.string.length();
        for (int index = 0; index < length; ++index) {
            char next;
            int indexEnd;
            char letter = this.string.charAt(index);
            if (letter == '\\' && index != length - 1 && this.string.charAt(index + 1) == '<') {
                ++index;
                consumer.accept(Character.valueOf('<'));
                continue;
            }
            if (letter == '<' && index != length - 1 && (indexEnd = ParserUtils.findUnescapedUnquotedChar(this.string, '>', index)) != -1 && (next = this.string.charAt(index + 1)) != '>') {
                String bracketsContent;
                boolean closeTag = false;
                if (next == '/') {
                    closeTag = true;
                    ++index;
                }
                String tagName = bracketsContent = this.string.substring(index + 1, indexEnd);
                String tagContent = null;
                int semicolonIndex = bracketsContent.indexOf(58);
                if (semicolonIndex >= 0) {
                    tagName = bracketsContent.substring(0, semicolonIndex);
                    tagContent = bracketsContent.substring(semicolonIndex + 1);
                } else if (tagName.startsWith("#")) {
                    tagName = "#";
                    tagContent = bracketsContent;
                }
                Tag tag = Tags.getTag(tagName);
                if (tag != null) {
                    if (mode == Mode.PARSE) {
                        if (this.tagPool.isGoodTag(tag)) {
                            this.proceedTag(tag, closeTag, tagContent);
                        }
                        index = indexEnd;
                        continue;
                    }
                    if (!this.tagPool.isGoodTag(tag)) {
                        index = indexEnd;
                        continue;
                    }
                }
                if (closeTag) {
                    --index;
                }
            }
            consumer.accept(Character.valueOf(letter));
        }
    }

    /*
     * Unable to fully structure code
     */
    private void proceedTag(@NotNull Tag tag, boolean closeTag, @Nullable String tagContent) {
        if (closeTag && !tag.isCloseable()) {
            return;
        }
        if (tag instanceof PlaceholderTag) {
            placeholderTag = (PlaceholderTag)tag;
            this.currentNode().append(placeholderTag.getValue());
            return;
        }
        if (tag instanceof TranslationTag) {
            if (tagContent != null) {
                if (tagContent.endsWith("/")) {
                    tagContent = tagContent.substring(0, tagContent.length() - 1);
                }
                key = (index = ParserUtils.findUnescapedUnquotedChar(tagContent, ':', 0)) < 0 ? tagContent : tagContent.substring(0, index);
                fallback = index < 0 || index >= tagContent.length() ? null : ParserUtils.unquoted(tagContent.substring(index + 1));
                this.currentGroup.createLangNode(ParserUtils.unquoted(key), fallback);
                this.currentNode = null;
            }
            return;
        }
        this.currentNode = null;
        if (closeTag) {
            this.toParentGroup(tag.getName());
            return;
        }
        if (tag instanceof ResetTag) {
            this.currentGroup = this.rootGroup;
            return;
        }
        this.currentGroup = this.currentGroup.createChildren(tag.getName());
        decorator = null;
        if (!(tag instanceof ContentTag)) ** GOTO lbl-1000
        contentTag = (ContentTag)tag;
        if (tagContent != null) {
            decorator = contentTag.parse(tagContent);
        } else if (tag instanceof Decorator) {
            decorator = tagDecorator = (Decorator)tag;
        }
        if (decorator != null) {
            this.currentGroup.addDecorator(decorator);
        }
    }

    public String getString() {
        return this.string;
    }

    public TextGroup getRootGroup() {
        return this.rootGroup;
    }

    public NightComponent getComponent() {
        return this.component;
    }

    public static enum Mode {
        PARSE,
        STRIP;

    }
}

