/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.nightcore.bridge.text.event;

import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.nightcore.util.bridge.wrapper.NightComponent;

public class NightHoverEvent<V> {
    private final Action<V> action;
    private final V value;

    @NotNull
    public static NightHoverEvent<NightComponent> showText(@NotNull NightComponent text) {
        return new NightHoverEvent<NightComponent>(Action.SHOW_TEXT, text);
    }

    @NotNull
    public static NightHoverEvent<ItemStack> showItem(@NotNull ItemStack itemStack) {
        return new NightHoverEvent<ItemStack>(Action.SHOW_ITEM, itemStack);
    }

    @NotNull
    public static <V> NightHoverEvent<V> hoverEvent(@NotNull Action<V> action, @NotNull V value) {
        return new NightHoverEvent<V>(action, value);
    }

    private NightHoverEvent(@NotNull Action<V> action, @NotNull V value) {
        this.action = action;
        this.value = value;
    }

    @NotNull
    public Action<V> action() {
        return this.action;
    }

    @NotNull
    public V value() {
        return this.value;
    }

    public static final class Action<V> {
        public static final Action<NightComponent> SHOW_TEXT = new Action<NightComponent>(NightComponent.class, "show_text");
        public static final Action<ItemStack> SHOW_ITEM = new Action<ItemStack>(ItemStack.class, "show_item");
        private final Class<V> type;
        private final String name;

        public static Action<?>[] values() {
            return new Action[]{SHOW_TEXT, SHOW_ITEM};
        }

        @Nullable
        public static Action<?> byName(@NotNull String name) {
            for (Action<?> action : Action.values()) {
                if (!name.equalsIgnoreCase(action.name())) continue;
                return action;
            }
            return null;
        }

        Action(@NotNull Class<V> type, @NotNull String name) {
            this.type = type;
            this.name = name;
        }

        @NotNull
        public String name() {
            return this.name;
        }

        @NotNull
        public Class<V> type() {
            return this.type;
        }
    }
}

