/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.nightcore;

import java.util.function.Consumer;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.scheduler.BukkitScheduler;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.command.CommandManager;
import su.nightexpress.nightcore.command.api.NightPluginCommand;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.config.PluginDetails;
import su.nightexpress.nightcore.language.LangManager;
import su.nightexpress.nightcore.locale.LangContainer;
import su.nightexpress.nightcore.ui.inventory.MenuRegistry;
import su.nightexpress.nightcore.util.wrapper.UniTask;

public interface NightCorePlugin
extends Plugin {
    public void enable();

    public void disable();

    public void reload();

    @Deprecated
    public NightPluginCommand getBaseCommand();

    @NotNull
    public FileConfig getConfig();

    @Deprecated
    @NotNull
    public FileConfig getLang();

    @NotNull
    public PluginDetails getDetails();

    public void extractResources(@NotNull String var1);

    public void extractResources(@NotNull String var1, @NotNull String var2);

    public void injectLang(@NotNull LangContainer var1);

    @NotNull
    default public String getNameLocalized() {
        return this.getDetails().getName();
    }

    @NotNull
    default public String getPrefix() {
        return this.getDetails().getPrefix();
    }

    @NotNull
    default public String[] getCommandAliases() {
        return this.getDetails().getCommandAliases();
    }

    @Deprecated
    @NotNull
    default public String getLanguage() {
        return this.getDetails().getLanguage();
    }

    default public void info(@NotNull String msg) {
        this.getLogger().info(msg);
    }

    default public void warn(@NotNull String msg) {
        this.getLogger().warning(msg);
    }

    default public void error(@NotNull String msg) {
        this.getLogger().severe(msg);
    }

    default public void debug(@NotNull String msg) {
        this.info("[DEBUG] " + msg);
    }

    @Deprecated
    @NotNull
    public LangManager getLangManager();

    @Deprecated
    @NotNull
    public CommandManager getCommandManager();

    @NotNull
    public MenuRegistry getMenuRegistry();

    @NotNull
    default public BukkitScheduler getScheduler() {
        return this.getServer().getScheduler();
    }

    @NotNull
    default public PluginManager getPluginManager() {
        return this.getServer().getPluginManager();
    }

    public void runTask(@NotNull Runnable var1);

    default public void runTask(@NotNull Consumer<BukkitTask> consumer) {
        this.getScheduler().runTask((Plugin)this, consumer);
    }

    default public void runTaskAsync(@NotNull Consumer<BukkitTask> consumer) {
        this.getScheduler().runTaskAsynchronously((Plugin)this, consumer);
    }

    default public void runTaskLater(@NotNull Consumer<BukkitTask> consumer, long delay) {
        this.getScheduler().runTaskLater((Plugin)this, consumer, delay);
    }

    default public void runTaskLaterAsync(@NotNull Consumer<BukkitTask> consumer, long delay) {
        this.getScheduler().runTaskLaterAsynchronously((Plugin)this, consumer, delay);
    }

    default public void runTaskTimer(@NotNull Consumer<BukkitTask> consumer, long delay, long interval) {
        this.getScheduler().runTaskTimer((Plugin)this, consumer, delay, interval);
    }

    default public void runTaskTimerAsync(@NotNull Consumer<BukkitTask> consumer, long delay, long interval) {
        this.getScheduler().runTaskTimerAsynchronously((Plugin)this, consumer, delay, interval);
    }

    @Deprecated
    @NotNull
    default public UniTask createTask(@NotNull Runnable runnable) {
        return new UniTask(this, runnable);
    }

    @Deprecated
    @NotNull
    default public UniTask createAsyncTask(@NotNull Runnable runnable) {
        return this.createTask(runnable).setAsync();
    }
}

