/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.utils;

import java.util.concurrent.atomic.AtomicInteger;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.nightcore.util.ItemUtil;

public class ItemStackUtils {
    public static void repairItem(@Nullable ItemStack itemStack) {
        if (itemStack == null || !ItemStackUtils.isDamageable(itemStack)) {
            return;
        }
        ItemStackUtils.setItemDamage(itemStack, 0);
    }

    public static boolean isDamageable(@NotNull ItemStack itemStack) {
        return itemStack.getType().getMaxDurability() > 0;
    }

    public static int setItemDamage(@NotNull ItemStack itemStack, int damage) {
        if (!ItemStackUtils.isDamageable(itemStack)) {
            throw new IllegalStateException("Item can not be damaged");
        }
        AtomicInteger result = new AtomicInteger(damage);
        ItemUtil.editMeta((ItemStack)itemStack, Damageable.class, meta -> {
            if (meta.getDamage() == damage) {
                return;
            }
            int absDamage = Math.max(0, damage);
            short maxDamage = itemStack.getType().getMaxDurability();
            int finalDamage = Math.min(absDamage, maxDamage);
            meta.setDamage(finalDamage);
            result.set(finalDamage);
        });
        return result.get();
    }

    public static void addEnchantment(@NotNull ItemStack itemStack, @NotNull Enchantment enchantment, int level) {
        ItemUtil.editMeta((ItemStack)itemStack, meta -> {
            if (meta instanceof EnchantmentStorageMeta) {
                EnchantmentStorageMeta storageMeta = (EnchantmentStorageMeta)meta;
                if (level > 0) {
                    storageMeta.addStoredEnchant(enchantment, level, true);
                } else {
                    storageMeta.removeStoredEnchant(enchantment);
                }
            } else if (level > 0) {
                meta.addEnchant(enchantment, level, true);
            } else {
                meta.removeEnchant(enchantment);
            }
        });
    }

    public static void removeEnchantment(@NotNull ItemStack itemStack, @NotNull Enchantment enchantment) {
        ItemUtil.editMeta((ItemStack)itemStack, meta -> {
            if (meta instanceof EnchantmentStorageMeta) {
                EnchantmentStorageMeta storageMeta = (EnchantmentStorageMeta)meta;
                storageMeta.removeStoredEnchant(enchantment);
            } else {
                meta.removeEnchant(enchantment);
            }
        });
    }

    public static void removeEnchantments(@NotNull ItemStack itemStack) {
        ItemUtil.editMeta((ItemStack)itemStack, meta -> {
            if (meta instanceof EnchantmentStorageMeta) {
                EnchantmentStorageMeta storageMeta = (EnchantmentStorageMeta)meta;
                storageMeta.getStoredEnchants().keySet().forEach(arg_0 -> ((EnchantmentStorageMeta)storageMeta).removeStoredEnchant(arg_0));
            } else {
                meta.getEnchants().keySet().forEach(arg_0 -> ((ItemMeta)meta).removeEnchant(arg_0));
            }
        });
    }
}

