/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.user;

import java.net.InetAddress;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.bukkit.entity.Player;
import org.jspecify.annotations.NonNull;
import su.nightexpress.nightcore.NightPlugin;
import su.nightexpress.nightcore.db.AbstractDatabaseManager;
import su.nightexpress.nightcore.manager.SimpeListener;
import su.nightexpress.nightcore.user.AbstractUserManager;
import su.nightexpress.nightcore.user.UserInfo;
import su.nightexpress.nightcore.user.data.DefaultUserDataAccessor;
import su.nightexpress.nightcore.user.data.UserDataAccessor;
import su.nightexpress.nightcore.user.data.UserDataSchema;
import su.nightexpress.nightcore.util.Players;
import su.nightexpress.sunlight.SLUtils;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.command.CommandKey;
import su.nightexpress.sunlight.data.DataHandler;
import su.nightexpress.sunlight.user.SunUser;
import su.nightexpress.sunlight.user.UserListener;

public class UserManager
extends AbstractUserManager<SunLightPlugin, SunUser> {
    private final DataHandler dataHandler;

    public UserManager(@NonNull SunLightPlugin plugin, @NonNull DataHandler dataHandler) {
        super((NightPlugin)plugin, (UserDataAccessor)new DefaultUserDataAccessor((AbstractDatabaseManager)dataHandler, (UserDataSchema)dataHandler));
        this.dataHandler = dataHandler;
    }

    protected void onLoad() {
        super.onLoad();
        this.addListener((SimpeListener)new UserListener((SunLightPlugin)this.plugin, this));
    }

    protected void synchronize(@NonNull SunUser fetched, @NonNull SunUser cached) {
        cached.updateFrom(fetched);
    }

    protected @NonNull SunUser create(@NonNull UUID uuid, @NonNull String name, @NonNull InetAddress address) {
        long timestamp = System.currentTimeMillis();
        HashMap<CommandKey, Long> commandCooldowns = new HashMap<CommandKey, Long>();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        SunUser user = new SunUser(uuid, name, timestamp, timestamp, address, commandCooldowns, properties);
        user.setFirstTimeJoined(true);
        return user;
    }

    public @NonNull CompletableFuture<Player> loadTargetPlayer(@NonNull String playerName) {
        return this.loadTargetProfile(playerName).thenCompose(this::loadTargetPlayer);
    }

    public @NonNull CompletableFuture<Player> loadTargetPlayer(@NonNull UserInfo profile) {
        return this.loadTargetPlayer(profile.id(), profile.name());
    }

    public @NonNull CompletableFuture<Player> loadTargetPlayer(@NonNull SunUser user) {
        return this.loadTargetPlayer(user.getId(), user.getName());
    }

    public @NonNull CompletableFuture<Player> loadTargetPlayer(@NonNull UUID id, @NonNull String name) {
        Player target = Players.getPlayer((UUID)id);
        if (target != null) {
            return CompletableFuture.completedFuture(target);
        }
        return CompletableFuture.supplyAsync(() -> ((SunLightPlugin)this.plugin).internals().map(nms -> nms.loadPlayerData(id, name)).orElse(null));
    }

    public @NonNull CompletableFuture<UserInfo> loadTargetProfile(@NonNull String playerName) {
        Player target = Players.getPlayer((String)playerName);
        if (target != null) {
            return CompletableFuture.completedFuture(UserInfo.of((Player)target));
        }
        return CompletableFuture.supplyAsync(() -> this.dataHandler.loadProfile(playerName).orElse(null));
    }

    public @NonNull CompletableFuture<InetAddress> loadInetAddress(@NonNull UUID playerId) {
        Player target = Players.getPlayer((UUID)playerId);
        if (target != null) {
            return CompletableFuture.completedFuture(SLUtils.getInetAddress(target).orElse(null));
        }
        return CompletableFuture.supplyAsync(() -> this.dataHandler.loadInetAddress(playerId).orElse(null));
    }
}

