/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.teleport;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import su.nightexpress.sunlight.module.Module;
import su.nightexpress.sunlight.teleport.TeleportFlag;

public class TeleportContext {
    private final Module module;
    private final CommandSender sender;
    private final Player target;
    private final EnumSet<TeleportFlag> flags;
    private final Runnable callback;
    private Location destination;

    public TeleportContext(@NonNull Module module, @Nullable CommandSender sender, @NonNull Player target, @NonNull Location destination, @NonNull EnumSet<TeleportFlag> flags, @Nullable Runnable callback) {
        this.module = module;
        this.sender = sender;
        this.target = target;
        this.flags = flags;
        this.callback = callback;
        this.setDestination(destination);
    }

    public static @NonNull Builder builder(@NonNull Module module, @NonNull Player target, @NonNull Location destination) {
        return new Builder(module, target, destination);
    }

    public void runCallback() {
        if (this.hasCallback()) {
            this.callback.run();
        }
    }

    public boolean hasSender() {
        return this.sender != null;
    }

    public boolean hasFlags() {
        return !this.flags.isEmpty();
    }

    public boolean hasFlag(@NonNull TeleportFlag flag) {
        return this.flags.contains((Object)flag);
    }

    public boolean hasCallback() {
        return this.callback != null;
    }

    public @NonNull CommandSender getExecutor() {
        return this.hasSender() ? this.sender : this.target;
    }

    public @NonNull Module getModule() {
        return this.module;
    }

    public @Nullable CommandSender getSender() {
        return this.sender;
    }

    public @NonNull Player getTarget() {
        return this.target;
    }

    public @NonNull Location getDestination() {
        return this.destination;
    }

    public void setDestination(@NonNull Location destination) {
        this.destination = destination.clone();
    }

    public @NonNull EnumSet<TeleportFlag> getFlags() {
        return this.flags;
    }

    public @Nullable Runnable getCallback() {
        return this.callback;
    }

    public static class Builder {
        private final Module module;
        private final Player target;
        private final Location destination;
        private final Set<TeleportFlag> flags;
        private CommandSender sender;
        private Runnable callback;

        Builder(@NonNull Module module, @NonNull Player target, @NonNull Location destination) {
            this.module = module;
            this.target = target;
            this.destination = destination.clone();
            this.flags = new HashSet<TeleportFlag>();
        }

        public @NonNull TeleportContext build() {
            EnumSet<TeleportFlag> flagSet = this.flags.isEmpty() ? EnumSet.noneOf(TeleportFlag.class) : EnumSet.copyOf(this.flags);
            return new TeleportContext(this.module, this.sender, this.target, this.destination, flagSet, this.callback);
        }

        public @NonNull Builder sender(@NonNull CommandSender sender) {
            if (sender != this.target) {
                this.sender = sender;
            }
            return this;
        }

        public @NonNull Builder withFlag(@NonNull TeleportFlag flag) {
            this.flags.add(flag);
            return this;
        }

        public @NonNull Builder withFlagIf(@NonNull TeleportFlag flag, @NonNull Supplier<Boolean> predicate) {
            if (predicate.get().booleanValue()) {
                return this.withFlag(flag);
            }
            return this;
        }

        public @NonNull Builder callback(@NonNull Runnable callback) {
            this.callback = callback;
            return this;
        }
    }
}

