/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.nms.mc_1_21_11;

import com.mojang.authlib.GameProfile;
import java.lang.reflect.Method;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundPlayerChatPacket;
import net.minecraft.network.protocol.game.ClientboundSystemChatPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedPlayerList;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.ClientInformation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.ServerPlayerGameMode;
import net.minecraft.server.players.NameAndId;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.inventory.CartographyTableMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.CraftingMenu;
import net.minecraft.world.inventory.EnchantmentMenu;
import net.minecraft.world.inventory.GrindstoneMenu;
import net.minecraft.world.inventory.LoomMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SmithingMenu;
import net.minecraft.world.inventory.StonecutterMenu;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.ValueInput;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.craftbukkit.entity.CraftFallingBlock;
import org.bukkit.craftbukkit.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.util.Reflex;
import su.nightexpress.sunlight.api.PortableContainer;
import su.nightexpress.sunlight.nms.SunNMS;
import su.nightexpress.sunlight.nms.mc_1_21_11.container.PlayerEnderChest;
import su.nightexpress.sunlight.nms.mc_1_21_11.container.PlayerInventory;

public class MC_1_21_11
implements SunNMS {
    private static final Method SET_GAME_MODE = Reflex.safeMethod(ServerPlayerGameMode.class, (String)"setGameModeForPlayer", (String)"a", (Class[])new Class[]{GameType.class, GameType.class});
    private static final Method OPEN_CUSTOM_INVENTORY = Reflex.safeMethod(CraftHumanEntity.class, (String)"openCustomInventory", (Class[])new Class[]{Inventory.class, ServerPlayer.class, MenuType.class});

    @Override
    public void dropFallingContent(@NotNull FallingBlock fallingBlock) {
        CraftFallingBlock craftBlock = (CraftFallingBlock)fallingBlock;
        FallingBlockEntity nmsBlock = craftBlock.getHandle();
        nmsBlock.spawnAtLocation((ServerLevel)nmsBlock.level(), (ItemLike)nmsBlock.getBlockState().getBlock());
    }

    @Override
    @NotNull
    public Object fineChatPacket(@NotNull Object packet) {
        ClientboundPlayerChatPacket chatPacket = (ClientboundPlayerChatPacket)packet;
        Component component = chatPacket.unsignedContent() == null ? Component.literal((String)chatPacket.body().content()) : chatPacket.unsignedContent();
        Holder typeHolder = chatPacket.chatType().chatType();
        ChatType.Bound decorator = new ChatType.Bound(typeHolder, chatPacket.chatType().name(), chatPacket.chatType().targetName());
        component = decorator.decorate(component);
        return new ClientboundSystemChatPacket(component, false);
    }

    @Override
    @NotNull
    public Player loadPlayerData(@NotNull UUID id, @NotNull String name) {
        CraftServer craftServer = (CraftServer)Bukkit.getServer();
        DedicatedServer server = craftServer.getServer();
        DedicatedPlayerList playerList = craftServer.getHandle();
        ServerLevel level = server.getLevel(Level.OVERWORLD);
        if (level == null) {
            throw new IllegalStateException("Server level is null");
        }
        GameProfile profile = new GameProfile(id, name);
        ServerPlayer serverPlayer = new ServerPlayer((MinecraftServer)server, level, profile, ClientInformation.createDefault());
        ProblemReporter.Collector reporter = new ProblemReporter.Collector();
        RegistryAccess access = serverPlayer.registryAccess();
        NameAndId nameAndId = new NameAndId(id, name);
        CompoundTag input = playerList.playerIo.load(nameAndId).orElse(new CompoundTag());
        ValueInput value = TagValueInput.create((ProblemReporter)reporter, (HolderLookup.Provider)access, (CompoundTag)input);
        serverPlayer.load(value);
        return serverPlayer.getBukkitEntity();
    }

    @Override
    public void setGameMode(@NotNull Player player, @NotNull GameMode mode) {
        CraftPlayer craftPlayer = (CraftPlayer)player;
        ServerPlayer serverPlayer = craftPlayer.getHandle();
        GameType gameType = GameType.byName((String)mode.name().toLowerCase());
        GameType previous = serverPlayer.gameMode.getPreviousGameModeForPlayer();
        Reflex.invokeMethod((Method)SET_GAME_MODE, (Object)serverPlayer.gameMode, (Object[])new Object[]{gameType, previous});
        craftPlayer.saveData();
    }

    @Override
    public void teleport(@NotNull Player player, @NotNull Location location) {
        CraftPlayer craftPlayer = (CraftPlayer)player;
        ServerPlayer serverPlayer = craftPlayer.getHandle();
        serverPlayer.setPosRaw(location.getX(), location.getY(), location.getZ());
        if (player.getWorld() != location.getWorld() && location.getWorld() != null) {
            CraftWorld craftWorld = (CraftWorld)location.getWorld();
            serverPlayer.setServerLevel(craftWorld.getHandle());
        }
        craftPlayer.saveData();
    }

    @Override
    @NotNull
    public Inventory getPlayerEnderChest(@NotNull Player player) {
        return new PlayerEnderChest((CraftPlayer)player).getInventory();
    }

    @Override
    @NotNull
    public Inventory getPlayerInventory(@NotNull Player player) {
        return new PlayerInventory((CraftPlayer)player).getInventory();
    }

    @Override
    public void openPlayerInventory(@NotNull Player player, @NotNull Player owner) {
        Inventory inventory = this.getPlayerInventory(owner);
        CraftPlayer craftPlayer = (CraftPlayer)player;
        ServerPlayer serverPlayer = craftPlayer.getHandle();
        Reflex.invokeMethod((Method)OPEN_CUSTOM_INVENTORY, null, (Object[])new Object[]{inventory, serverPlayer, MenuType.GENERIC_9x5});
    }

    @Override
    public void openContainer(@NotNull Player player, @NotNull PortableContainer menuType) {
        AbstractContainerMenu menu = this.createContainer(menuType, player);
        player.openInventory(menu.getBukkitView());
    }

    @NotNull
    private AbstractContainerMenu createContainer(@NotNull PortableContainer type, @NotNull Player player) {
        CraftPlayer craftPlayer = (CraftPlayer)player;
        ServerPlayer nmsPlayer = craftPlayer.getHandle();
        int contId = nmsPlayer.nextContainerCounter();
        ContainerLevelAccess access = ContainerLevelAccess.create((Level)nmsPlayer.level(), (BlockPos)nmsPlayer.blockPosition());
        net.minecraft.world.entity.player.Inventory inventory = nmsPlayer.getInventory();
        AnvilMenu menu = switch (type) {
            default -> throw new MatchException(null, null);
            case PortableContainer.ANVIL -> new AnvilMenu(contId, inventory, access);
            case PortableContainer.WORKBENCH -> new CraftingMenu(contId, inventory, access);
            case PortableContainer.ENCHANTING_TABLE -> new EnchantmentMenu(contId, inventory, access);
            case PortableContainer.LOOM -> new LoomMenu(contId, inventory, access);
            case PortableContainer.SMITHING_TABLE -> new SmithingMenu(contId, inventory, access);
            case PortableContainer.GRINDSTONE -> new GrindstoneMenu(contId, inventory, access);
            case PortableContainer.STONECUTTER -> new StonecutterMenu(contId, inventory, access);
            case PortableContainer.CARTOGRAPHY_TABLE -> new CartographyTableMenu(contId, inventory, access);
        };
        menu.checkReachable = false;
        return menu;
    }
}

