/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.nms.mc_1_21_10;

import com.mojang.authlib.GameProfile;
import java.lang.reflect.Method;
import java.util.UUID;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.ChatMessageType;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.ClientboundPlayerChatPacket;
import net.minecraft.network.protocol.game.ClientboundSystemChatPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedPlayerList;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.ClientInformation;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.PlayerInteractManager;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.players.NameAndId;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.item.EntityFallingBlock;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerAccess;
import net.minecraft.world.inventory.ContainerAnvil;
import net.minecraft.world.inventory.ContainerCartography;
import net.minecraft.world.inventory.ContainerEnchantTable;
import net.minecraft.world.inventory.ContainerGrindstone;
import net.minecraft.world.inventory.ContainerLoom;
import net.minecraft.world.inventory.ContainerSmithing;
import net.minecraft.world.inventory.ContainerStonecutter;
import net.minecraft.world.inventory.ContainerWorkbench;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.World;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.ValueInput;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R6.CraftServer;
import org.bukkit.craftbukkit.v1_21_R6.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftFallingBlock;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_21_R6.entity.CraftPlayer;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.util.Reflex;
import su.nightexpress.sunlight.api.PortableContainer;
import su.nightexpress.sunlight.nms.SunNMS;
import su.nightexpress.sunlight.nms.mc_1_21_10.container.PlayerEnderChest;
import su.nightexpress.sunlight.nms.mc_1_21_10.container.PlayerInventory;

public class MC_1_21_10
implements SunNMS {
    private static final Method SET_GAME_MODE = Reflex.getMethod(PlayerInteractManager.class, (String)"setGameModeForPlayer", (String)"a", (Class[])new Class[]{EnumGamemode.class, EnumGamemode.class});
    private static final Method OPEN_CUSTOM_INVENTORY = Reflex.getMethod(CraftHumanEntity.class, (String)"openCustomInventory", (Class[])new Class[]{Inventory.class, EntityPlayer.class, Containers.class});

    @Override
    public void dropFallingContent(@NotNull FallingBlock fallingBlock) {
        CraftFallingBlock craftBlock = (CraftFallingBlock)fallingBlock;
        EntityFallingBlock nmsBlock = craftBlock.getHandle();
        nmsBlock.a((WorldServer)nmsBlock.an(), (IMaterial)nmsBlock.i().b());
    }

    @Override
    @NotNull
    public Object fineChatPacket(@NotNull Object packet) {
        ClientboundPlayerChatPacket chatPacket = (ClientboundPlayerChatPacket)packet;
        IChatBaseComponent component = chatPacket.i() == null ? IChatBaseComponent.b((String)chatPacket.h().a()) : chatPacket.i();
        Holder typeHolder = chatPacket.k().a();
        ChatMessageType.a decorator = new ChatMessageType.a(typeHolder, chatPacket.k().b(), chatPacket.k().c());
        component = decorator.a(component);
        return new ClientboundSystemChatPacket(component, false);
    }

    @Override
    @NotNull
    public Player loadPlayerData(@NotNull UUID id, @NotNull String name) {
        CraftServer craftServer = (CraftServer)Bukkit.getServer();
        DedicatedServer server = craftServer.getServer();
        DedicatedPlayerList playerList = craftServer.getHandle();
        WorldServer level = server.a(World.h);
        if (level == null) {
            throw new IllegalStateException("Server level is null");
        }
        GameProfile profile = new GameProfile(id, name);
        EntityPlayer serverPlayer = new EntityPlayer((MinecraftServer)server, level, profile, ClientInformation.a());
        ProblemReporter.a reporter = new ProblemReporter.a();
        IRegistryCustom access = serverPlayer.ej();
        NameAndId nameAndId = new NameAndId(id, name);
        NBTTagCompound input = playerList.s.a(nameAndId).orElse(new NBTTagCompound());
        ValueInput value = TagValueInput.a((ProblemReporter)reporter, (HolderLookup.a)access, (NBTTagCompound)input);
        serverPlayer.d(value);
        return serverPlayer.getBukkitEntity();
    }

    @Override
    public void setGameMode(@NotNull Player player, @NotNull GameMode mode) {
        CraftPlayer craftPlayer = (CraftPlayer)player;
        EntityPlayer serverPlayer = craftPlayer.getHandle();
        EnumGamemode gameType = EnumGamemode.a((String)mode.name().toLowerCase());
        EnumGamemode previous = serverPlayer.h.c();
        Reflex.invokeMethod((Method)SET_GAME_MODE, (Object)serverPlayer.h, (Object[])new Object[]{gameType, previous});
        craftPlayer.saveData();
    }

    @Override
    public void teleport(@NotNull Player player, @NotNull Location location) {
        CraftPlayer craftPlayer = (CraftPlayer)player;
        EntityPlayer serverPlayer = craftPlayer.getHandle();
        serverPlayer.n(location.getX(), location.getY(), location.getZ());
        if (player.getWorld() != location.getWorld() && location.getWorld() != null) {
            CraftWorld craftWorld = (CraftWorld)location.getWorld();
            serverPlayer.a(craftWorld.getHandle());
        }
        craftPlayer.saveData();
    }

    @Override
    @NotNull
    public Inventory getPlayerEnderChest(@NotNull Player player) {
        return new PlayerEnderChest((CraftPlayer)player).getInventory();
    }

    @Override
    @NotNull
    public Inventory getPlayerInventory(@NotNull Player player) {
        return new PlayerInventory((CraftPlayer)player).getInventory();
    }

    @Override
    public void openPlayerInventory(@NotNull Player player, @NotNull Player owner) {
        if (OPEN_CUSTOM_INVENTORY == null) {
            return;
        }
        Inventory inventory = this.getPlayerInventory(owner);
        CraftPlayer craftPlayer = (CraftPlayer)player;
        EntityPlayer serverPlayer = craftPlayer.getHandle();
        Reflex.invokeMethod((Method)OPEN_CUSTOM_INVENTORY, null, (Object[])new Object[]{inventory, serverPlayer, Containers.e});
    }

    @Override
    public void openContainer(@NotNull Player player, @NotNull PortableContainer menuType) {
        Container menu = this.createContainer(menuType, player);
        player.openInventory(menu.getBukkitView());
    }

    @NotNull
    private Container createContainer(@NotNull PortableContainer type, @NotNull Player player) {
        CraftPlayer craftPlayer = (CraftPlayer)player;
        EntityPlayer nmsPlayer = craftPlayer.getHandle();
        int contId = nmsPlayer.nextContainerCounter();
        ContainerAccess access = ContainerAccess.a((World)nmsPlayer.A(), (BlockPosition)nmsPlayer.dF());
        net.minecraft.world.entity.player.PlayerInventory inventory = nmsPlayer.gB();
        ContainerAnvil menu = switch (type) {
            default -> throw new MatchException(null, null);
            case PortableContainer.ANVIL -> new ContainerAnvil(contId, inventory, access);
            case PortableContainer.WORKBENCH -> new ContainerWorkbench(contId, inventory, access);
            case PortableContainer.ENCHANTING_TABLE -> new ContainerEnchantTable(contId, inventory, access);
            case PortableContainer.LOOM -> new ContainerLoom(contId, inventory, access);
            case PortableContainer.SMITHING_TABLE -> new ContainerSmithing(contId, inventory, access);
            case PortableContainer.GRINDSTONE -> new ContainerGrindstone(contId, inventory, access);
            case PortableContainer.STONECUTTER -> new ContainerStonecutter(contId, inventory, access);
            case PortableContainer.CARTOGRAPHY_TABLE -> new ContainerCartography(contId, inventory, access);
        };
        menu.checkReachable = false;
        return menu;
    }
}

