/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.worlds.impl.generation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.bukkit.Material;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.generator.WorldInfo;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.util.Lists;
import su.nightexpress.nightcore.util.random.Rnd;
import su.nightexpress.sunlight.module.worlds.impl.generation.FastNoiseLite;

public class PlainsChunkGenerator
extends ChunkGenerator {
    public static final String NAME = "plains";
    private static final int Y_MAX = 90;
    private static final int Y_HALF = 45;
    private final FastNoiseLite terrainNoise = new FastNoiseLite();
    private final FastNoiseLite detailNoise = new FastNoiseLite();
    private static final List<Material> LAYER_SURFACE = Lists.newList((Object[])new Material[]{Material.GRASS_BLOCK});
    private static final List<Material> LAYER_SUB_SUFFACE = Lists.newList((Object[])new Material[]{Material.DIRT});
    private static final List<Material> LAYER_ORES = Lists.newList((Object[])new Material[]{Material.COAL_ORE, Material.IRON_ORE});
    private static final List<Material> LAYER_BOTTOM = Lists.newList((Object[])new Material[]{Material.BEDROCK});

    public PlainsChunkGenerator() {
        this.terrainNoise.SetFrequency(5.0E-4f);
        this.detailNoise.SetFrequency(0.05f);
        this.terrainNoise.SetFractalType(FastNoiseLite.FractalType.Ridged);
        this.terrainNoise.SetFractalOctaves(3);
    }

    public void generateNoise(@NotNull WorldInfo worldInfo, @NotNull Random random, int chunkX, int chunkZ, @NotNull ChunkGenerator.ChunkData chunkData) {
        for (int y = chunkData.getMinHeight(); y < 90 && y < chunkData.getMaxHeight(); ++y) {
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    if (y == 0) {
                        chunkData.setBlock(x, y, z, (Material)Rnd.get(LAYER_BOTTOM));
                        continue;
                    }
                    float terNoise = this.terrainNoise.GetNoise(x + chunkX * 16, z + chunkZ * 16) * 2.0f + this.detailNoise.GetNoise(x + chunkX * 16, z + chunkZ * 16) / 10.0f;
                    float detNoise = this.detailNoise.GetNoise(x + chunkX * 16, y, z + chunkZ * 16);
                    float currentY = 45.0f + terNoise * 10.0f;
                    if ((float)y < currentY) {
                        float distanceToSurface = Math.abs((float)y - currentY);
                        double function = 0.1 * Math.pow(distanceToSurface, 2.0) - 1.0;
                        if (!((double)detNoise > Math.min(function, -0.3))) continue;
                        if (distanceToSurface < 1.0f && y > 43) {
                            chunkData.setBlock(x, y, z, (Material)Rnd.get(LAYER_SURFACE));
                            continue;
                        }
                        if (distanceToSurface < 5.0f) {
                            chunkData.setBlock(x, y, z, (Material)Rnd.get(LAYER_SUB_SUFFACE));
                            continue;
                        }
                        Material neighbour = Material.STONE;
                        ArrayList<Material> neighbourBlocks = new ArrayList<Material>(Arrays.asList(chunkData.getType(Math.max(x - 1, 0), y, z), chunkData.getType(x, Math.max(y - 1, 0), z), chunkData.getType(x, y, Math.max(z - 1, 0))));
                        if ((double)random.nextFloat() < 0.002) {
                            neighbour = (Material)Rnd.get(LAYER_ORES);
                        }
                        if (!Collections.disjoint(neighbourBlocks, LAYER_ORES)) {
                            for (Material neighbourBlock : neighbourBlocks) {
                                if (!LAYER_ORES.contains(neighbourBlock) || !((double)random.nextFloat() < -0.01 * (double)LAYER_ORES.indexOf(neighbourBlock) + 0.4)) continue;
                                neighbour = neighbourBlock;
                            }
                        }
                        chunkData.setBlock(x, y, z, neighbour);
                        continue;
                    }
                    if (y >= 45) continue;
                    chunkData.setBlock(x, y, z, Material.WATER);
                }
            }
        }
    }
}

