/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.worlds.editor;

import org.bukkit.GameRule;
import org.bukkit.inventory.Inventory;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.NightCorePlugin;
import su.nightexpress.nightcore.menu.MenuOptions;
import su.nightexpress.nightcore.menu.MenuSize;
import su.nightexpress.nightcore.menu.MenuViewer;
import su.nightexpress.nightcore.menu.api.AutoFill;
import su.nightexpress.nightcore.menu.api.AutoFilled;
import su.nightexpress.nightcore.menu.impl.EditorMenu;
import su.nightexpress.nightcore.util.StringUtil;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.module.worlds.WorldsModule;
import su.nightexpress.sunlight.module.worlds.config.WorldsLang;
import su.nightexpress.sunlight.module.worlds.impl.WrappedWorld;

public class WorldRulesEditor
extends EditorMenu<SunLightPlugin, WrappedWorld>
implements AutoFilled<GameRule<?>> {
    public WorldRulesEditor(@NotNull SunLightPlugin plugin, @NotNull WorldsModule module) {
        super((NightCorePlugin)plugin, WorldsLang.EDITOR_TITLE_GAME_RULES.text(), MenuSize.CHEST_45);
        this.addNextPage(new int[]{44});
        this.addPreviousPage(new int[]{36});
        this.addReturn(40, (viewer, event, wrappedWorld) -> this.runNextTick(() -> module.openWorldSettings(viewer.getPlayer(), (WrappedWorld)wrappedWorld)));
    }

    public void onPrepare(@NotNull MenuViewer viewer, @NotNull MenuOptions options) {
        this.autoFill(viewer);
    }

    protected void onReady(@NotNull MenuViewer viewer, @NotNull Inventory inventory) {
    }

    public void onAutoFill(@NotNull MenuViewer viewer, @NotNull AutoFill<GameRule<?>> autoFill) {
    }

    @NotNull
    private String getRuleName(@NotNull String name) {
        StringBuilder builder = new StringBuilder();
        for (char letter : name.toCharArray()) {
            if (Character.isUpperCase(letter) && !builder.isEmpty()) {
                builder.append(" ");
            }
            builder.append(letter);
        }
        return StringUtil.capitalizeFully((String)builder.toString());
    }
}

