/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.warps.menu;

import java.util.List;
import java.util.stream.IntStream;
import org.bukkit.Material;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MenuType;
import org.jetbrains.annotations.NotNull;
import org.jspecify.annotations.NonNull;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.core.config.CoreLang;
import su.nightexpress.nightcore.ui.inventory.action.ObjectActionContext;
import su.nightexpress.nightcore.ui.inventory.item.ItemState;
import su.nightexpress.nightcore.ui.inventory.item.MenuItem;
import su.nightexpress.nightcore.ui.inventory.menu.AbstractObjectMenu;
import su.nightexpress.nightcore.ui.inventory.viewer.ViewerContext;
import su.nightexpress.nightcore.util.ArrayUtil;
import su.nightexpress.nightcore.util.Lists;
import su.nightexpress.nightcore.util.bukkit.NightItem;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrapper;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;
import su.nightexpress.sunlight.dialog.DialogKey;
import su.nightexpress.sunlight.dialog.DialogRegistry;
import su.nightexpress.sunlight.module.warps.Warp;
import su.nightexpress.sunlight.module.warps.WarpsModule;
import su.nightexpress.sunlight.module.warps.dialog.WarpsDialogKeys;

public class WarpOptionsMenu
extends AbstractObjectMenu<Warp> {
    private final WarpsModule manager;
    protected final DialogRegistry dialogRegistry;

    public WarpOptionsMenu(@NonNull WarpsModule manager, @NonNull DialogRegistry dialogRegistry) {
        super((MenuType)MenuType.GENERIC_9X5, "Warp Settings", Warp.class);
        this.manager = manager;
        this.dialogRegistry = dialogRegistry;
    }

    public void registerActions() {
    }

    public void registerConditions() {
    }

    public void defineDefaultLayout() {
        this.addBackgroundItem(Material.BLACK_STAINED_GLASS_PANE, IntStream.range(0, 9).toArray());
        this.addBackgroundItem(Material.BLACK_STAINED_GLASS_PANE, IntStream.range(36, 45).toArray());
        this.addDefaultButton("back", MenuItem.builder().defaultState(ItemState.defaultBuilder().icon(NightItem.fromType((Material)Material.COMPASS).setDisplayName(TagWrappers.GREEN.wrap("Back to Warps"))).action(this.createObjectAction(this::backToWarps)).build()).slots(new int[]{40}).build());
        this.addDefaultButton("name", MenuItem.builder().defaultState(ItemState.defaultBuilder().icon(NightItem.fromType((Material)Material.NAME_TAG).setDisplayName(TagWrappers.GOLD.and((TagWrapper)TagWrappers.BOLD).wrap("Name")).setLore(Lists.newList((Object[])new String[]{TagWrappers.DARK_GRAY.wrap("\u00bb " + TagWrappers.GRAY.wrap("Current: ") + TagWrappers.WHITE.wrap("%warp_name%")), "", TagWrappers.GOLD.wrap("\u2192 " + TagWrappers.UNDERLINED.wrap("Click to edit"))})).hideAllComponents()).displayModifier((context, item) -> item.replace(builder -> builder.with(((Warp)this.getObject(context)).placeholders()))).action(this.createObjectAction(this::editName)).build()).slots(new int[]{20}).build());
        this.addDefaultButton("description", MenuItem.builder().defaultState(ItemState.defaultBuilder().icon(NightItem.fromType((Material)Material.WRITABLE_BOOK).setDisplayName(TagWrappers.GOLD.and((TagWrapper)TagWrappers.BOLD).wrap("Description")).setLore(Lists.newList((Object[])new String[]{"%warp_description%", "", TagWrappers.GOLD.wrap("\u2192 " + TagWrappers.UNDERLINED.wrap("Click to edit"))})).hideAllComponents()).displayModifier((context, item) -> item.replace(builder -> builder.with(((Warp)this.getObject(context)).placeholders()))).action(this.createObjectAction(this::editDescription)).build()).slots(new int[]{21}).build());
        this.addDefaultButton("icon", MenuItem.builder().defaultState(ItemState.defaultBuilder().icon(NightItem.fromType((Material)Material.PAINTING).setDisplayName(TagWrappers.GOLD.and((TagWrapper)TagWrappers.BOLD).wrap("Icon")).setLore(Lists.newList((Object[])new String[]{TagWrappers.GRAY.wrap("Right click an item in your"), TagWrappers.GRAY.wrap("inventory to replace the icon.")})).hideAllComponents()).displayModifier((context, item) -> item.setMaterial(((Warp)this.getObject(context)).getIcon().getMaterial())).build()).slots(new int[]{22}).build());
        this.addDefaultButton("permission", MenuItem.builder().defaultState(ItemState.defaultBuilder().icon(NightItem.fromType((Material)Material.REDSTONE).setDisplayName(TagWrappers.RED.and((TagWrapper)TagWrappers.BOLD).wrap("Permission Requirement")).setLore(Lists.newList((Object[])new String[]{TagWrappers.DARK_GRAY.wrap("\u00bb " + TagWrappers.GRAY.wrap("Enabled: ") + TagWrappers.WHITE.wrap("%state%")), "", TagWrappers.RED.wrap("\u2192 " + TagWrappers.UNDERLINED.wrap("Click to toggle"))})).hideAllComponents()).displayModifier((context, item) -> item.replace(builder -> builder.with("%state%", () -> CoreLang.STATE_YES_NO.get(((Warp)this.getObject(context)).isPermissionRequired())))).action(this.createObjectAction(this::editPermission)).build()).slots(new int[]{23}).build());
        this.addDefaultButton("slots", MenuItem.builder().defaultState(ItemState.defaultBuilder().icon(NightItem.fromType((Material)Material.ITEM_FRAME).setDisplayName(TagWrappers.GOLD.and((TagWrapper)TagWrappers.BOLD).wrap("Page & Slots")).setLore(Lists.newList((Object[])new String[]{TagWrappers.DARK_GRAY.wrap("\u00bb " + TagWrappers.GRAY.wrap("Page: ") + TagWrappers.WHITE.wrap("%page%")), TagWrappers.DARK_GRAY.wrap("\u00bb " + TagWrappers.GRAY.wrap("Slots: ") + TagWrappers.WHITE.wrap("%slot%")), "", TagWrappers.GOLD.wrap("\u2192 " + TagWrappers.UNDERLINED.wrap("Click to edit"))})).hideAllComponents()).displayModifier((context, item) -> item.replace(builder -> builder.with("%page%", () -> String.valueOf(((Warp)this.getObject(context)).getMenuPage())).with("%slot%", () -> ArrayUtil.arrayToString((int[])((Warp)this.getObject(context)).getMenuSlots())))).action(this.createObjectAction(this::editSlots)).build()).slots(new int[]{24}).build());
        this.addDefaultButton("command", MenuItem.builder().defaultState(ItemState.defaultBuilder().icon(NightItem.fromType((Material)Material.COMMAND_BLOCK).setDisplayName(TagWrappers.ORANGE.and((TagWrapper)TagWrappers.BOLD).wrap("Command Alias")).setLore(Lists.newList((Object[])new String[]{TagWrappers.DARK_GRAY.wrap("\u00bb " + TagWrappers.GRAY.wrap("Enabled: ") + TagWrappers.WHITE.wrap("%state%")), TagWrappers.DARK_GRAY.wrap("\u00bb " + TagWrappers.GRAY.wrap("Current: ") + TagWrappers.WHITE.wrap("%value%")), "", TagWrappers.ORANGE.wrap("\u2192 " + TagWrappers.UNDERLINED.wrap("Click to edit"))})).hideAllComponents()).displayModifier((context, item) -> item.replace(builder -> builder.with("%state%", () -> CoreLang.STATE_YES_NO.get(((Warp)this.getObject(context)).isCommandEnabled())).with("%value%", () -> "/" + ((Warp)this.getObject(context)).getCommandLabel()))).action(this.createObjectAction(this::editCommand)).build()).slots(new int[]{4}).build());
    }

    protected void backToWarps(@NonNull ObjectActionContext<Warp> context) {
        this.manager.openWarpsMenu(context.getPlayer());
    }

    private void editPermission(@NonNull ObjectActionContext<Warp> context) {
        Warp warp;
        warp.setPermissionRequired(!(warp = (Warp)context.getObject()).isPermissionRequired());
        warp.markDirty();
        context.getViewer().refresh();
    }

    private void editName(@NonNull ObjectActionContext<Warp> context) {
        this.openDialog(context, WarpsDialogKeys.WARP_NAME);
    }

    private void editDescription(@NonNull ObjectActionContext<Warp> context) {
        this.openDialog(context, WarpsDialogKeys.WARP_DESCRIPTION);
    }

    private void editSlots(@NonNull ObjectActionContext<Warp> context) {
        this.openDialog(context, WarpsDialogKeys.WARP_SLOTS);
    }

    private void editCommand(@NonNull ObjectActionContext<Warp> context) {
        this.openDialog(context, WarpsDialogKeys.WARP_COMMAND);
    }

    private void openDialog(@NonNull ObjectActionContext<Warp> context, @NonNull DialogKey<Warp> key) {
        this.dialogRegistry.show(context.getPlayer(), key, (Warp)context.getObject(), () -> context.getViewer().refresh());
    }

    protected void onLoad(@NotNull FileConfig config) {
    }

    protected void onClick(@NotNull ViewerContext context, @NotNull InventoryClickEvent event) {
        if (event.isRightClick() && event.getRawSlot() >= event.getInventory().getSize()) {
            ItemStack itemStack = event.getCurrentItem();
            if (itemStack == null || itemStack.getType().isAir()) {
                return;
            }
            Warp warp = (Warp)this.getObject(context);
            warp.setIcon(NightItem.fromItemStack((ItemStack)itemStack).hideAllComponents().ignoreNameAndLore());
            warp.markDirty();
            context.getViewer().refresh();
        }
    }

    protected void onDrag(@NotNull ViewerContext context, @NotNull InventoryDragEvent event) {
    }

    protected void onClose(@NotNull ViewerContext context, @NotNull InventoryCloseEvent event) {
    }

    public void onPrepare(@NotNull ViewerContext context, @NotNull InventoryView view, @NotNull Inventory inventory, @NotNull List<MenuItem> items) {
    }

    public void onReady(@NotNull ViewerContext context, @NotNull InventoryView view, @NotNull Inventory inventory) {
    }

    public void onRender(@NotNull ViewerContext context, @NotNull InventoryView view, @NotNull Inventory inventory) {
    }
}

