/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.warps.menu;

import java.util.List;
import java.util.Set;
import java.util.stream.IntStream;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.MenuType;
import org.jetbrains.annotations.NotNull;
import org.jspecify.annotations.NonNull;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.locale.LangContainer;
import su.nightexpress.nightcore.locale.LangEntry;
import su.nightexpress.nightcore.locale.entry.IconLocale;
import su.nightexpress.nightcore.ui.inventory.item.ItemState;
import su.nightexpress.nightcore.ui.inventory.item.MenuItem;
import su.nightexpress.nightcore.ui.inventory.menu.AbstractMenu;
import su.nightexpress.nightcore.ui.inventory.viewer.MenuViewer;
import su.nightexpress.nightcore.ui.inventory.viewer.ViewerContext;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;
import su.nightexpress.sunlight.module.warps.Warp;
import su.nightexpress.sunlight.module.warps.WarpsModule;

public class WarpListMenu
extends AbstractMenu
implements LangContainer {
    private static final IconLocale ICON_WARP_DEFAULT = LangEntry.iconBuilder((String)"Warps.UI.WarpsMenu.WarpDefault").rawName("%warp_name%").rawLore(new String[]{"%warp_description%", "%empty-if-above%", TagWrappers.GOLD.wrap("\u2192 " + TagWrappers.UNDERLINED.wrap("Click to teleport"))}).build();
    private static final IconLocale ICON_WARP_MODERATE = LangEntry.iconBuilder((String)"Warps.UI.WarpsMenu.WarpModerate").rawName("%warp_name%").rawLore(new String[]{"%warp_description%", "%empty-if-above%", TagWrappers.GOLD.wrap("\u2192 " + TagWrappers.UNDERLINED.wrap("Left-Click to teleport")), TagWrappers.GOLD.wrap("\u2192 " + TagWrappers.UNDERLINED.wrap("Right-Click to edit"))}).build();
    private final WarpsModule module;

    public WarpListMenu(@NonNull WarpsModule module) {
        super((MenuType)MenuType.GENERIC_9X6, "Server Warps");
        this.module = module;
    }

    public void registerActions() {
    }

    public void registerConditions() {
    }

    public void defineDefaultLayout() {
        this.addBackgroundItem(Material.BLACK_STAINED_GLASS_PANE, IntStream.range(0, 9).toArray());
        this.addBackgroundItem(Material.BLACK_STAINED_GLASS_PANE, IntStream.range(45, 54).toArray());
        this.addBackgroundItem(Material.GRAY_STAINED_GLASS_PANE, IntStream.range(9, 45).toArray());
        this.addNextPageItem(Material.ARROW, new int[]{53});
        this.addPreviousPageItem(Material.ARROW, new int[]{45});
    }

    protected void onLoad(@NotNull FileConfig config) {
    }

    protected void onClick(@NotNull ViewerContext context, @NotNull InventoryClickEvent event) {
    }

    protected void onDrag(@NotNull ViewerContext context, @NotNull InventoryDragEvent event) {
    }

    protected void onClose(@NotNull ViewerContext context, @NotNull InventoryCloseEvent event) {
    }

    public void onPrepare(@NotNull ViewerContext context, @NotNull InventoryView view, @NotNull Inventory inventory, @NotNull List<MenuItem> items) {
        Player player = context.getPlayer();
        MenuViewer viewer = context.getViewer();
        Set<Warp> warps = this.module.getAvailableWarps(player);
        int maxPages = warps.stream().mapToInt(Warp::getMenuPage).max().orElse(1);
        viewer.setTotalPages(maxPages);
        warps.stream().filter(warp -> warp.getMenuPage() == viewer.getCurrentPage()).forEach(warp -> items.add(MenuItem.builder().defaultState(ItemState.defaultBuilder().icon(warp.getIcon().localized(warp.canEdit(player) ? ICON_WARP_MODERATE : ICON_WARP_DEFAULT).replace(builder -> builder.with(warp.placeholders()))).action(ctx -> this.module.clickWarp(ctx, (Warp)warp)).build()).slots(warp.getMenuSlots()).build()));
    }

    public void onReady(@NotNull ViewerContext context, @NotNull InventoryView view, @NotNull Inventory inventory) {
    }

    public void onRender(@NotNull ViewerContext context, @NotNull InventoryView view, @NotNull Inventory inventory) {
    }
}

