/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.warps.dialog.impl;

import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.jspecify.annotations.NonNull;
import su.nightexpress.nightcore.bridge.dialog.wrap.WrappedDialog;
import su.nightexpress.nightcore.bridge.dialog.wrap.body.WrappedDialogBody;
import su.nightexpress.nightcore.bridge.dialog.wrap.button.WrappedActionButton;
import su.nightexpress.nightcore.bridge.dialog.wrap.input.WrappedDialogInput;
import su.nightexpress.nightcore.bridge.dialog.wrap.type.WrappedDialogType;
import su.nightexpress.nightcore.locale.LangEntry;
import su.nightexpress.nightcore.locale.entry.DialogElementLocale;
import su.nightexpress.nightcore.locale.entry.TextLocale;
import su.nightexpress.nightcore.ui.dialog.Dialogs;
import su.nightexpress.nightcore.ui.dialog.build.DialogBases;
import su.nightexpress.nightcore.ui.dialog.build.DialogBodies;
import su.nightexpress.nightcore.ui.dialog.build.DialogButtons;
import su.nightexpress.nightcore.ui.dialog.build.DialogInputs;
import su.nightexpress.nightcore.ui.dialog.build.DialogTypes;
import su.nightexpress.nightcore.util.ArrayUtil;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;
import su.nightexpress.sunlight.dialog.Dialog;
import su.nightexpress.sunlight.module.warps.Warp;

public class WarpSlotsDialog
extends Dialog<Warp> {
    private static final TextLocale TITLE = LangEntry.builder((String)"Warps.Dialog.WarpSlots.Title").text(WarpSlotsDialog.title("Warp", "Slots"));
    private static final DialogElementLocale BODY = LangEntry.builder((String)"Warps.Dialog.WarpSlots.Body").dialogElement(400, new String[]{"Specify the " + TagWrappers.YELLOW.wrap("slots") + " and " + TagWrappers.YELLOW.wrap("page number") + " where this warp will be displayed in the GUI.", "", "Slot numbers start " + TagWrappers.ORANGE.wrap("at 0") + " and should be separated by commas " + TagWrappers.GRAY.wrap("(e.g., 1, 2, 10, 11)") + ".", "", "The " + TagWrappers.YELLOW.wrap("total number") + " of GUI pages is determined by the " + TagWrappers.YELLOW.wrap("highest") + " page number assigned to any warp.", "", "You can set the page number to " + TagWrappers.RED.wrap("0") + " to hide this warp from the GUI."});
    private static final TextLocale INPUT_PAGE = LangEntry.builder((String)"Warps.Dialog.WarpSlots.Input.Page").text((String)TagWrappers.SPRITE_ITEM.apply(Material.PAPER) + " Page");
    private static final TextLocale INPUT_SLOTS = LangEntry.builder((String)"Warps.Dialog.WarpSlots.Input.Name").text((String)TagWrappers.SPRITE_ITEM.apply(Material.ITEM_FRAME) + " Slots");
    private static final String JSON_PAGE = "page";
    private static final String JSON_SLOTS = "slots";

    @Override
    public @NonNull WrappedDialog create(@NonNull Player player, @NonNull Warp warp) {
        return Dialogs.builder().base(DialogBases.builder((TextLocale)TITLE).body(new WrappedDialogBody[]{DialogBodies.plainMessage((DialogElementLocale)BODY)}).inputs(new WrappedDialogInput[]{DialogInputs.text((String)JSON_PAGE, (TextLocale)INPUT_PAGE).maxLength(2).initial(String.valueOf(warp.getMenuPage())).build(), DialogInputs.text((String)JSON_SLOTS, (TextLocale)INPUT_SLOTS).maxLength(30).initial(ArrayUtil.arrayToString((int[])warp.getMenuSlots())).build()}).build()).type((WrappedDialogType)DialogTypes.multiAction((WrappedActionButton[])new WrappedActionButton[]{DialogButtons.ok()}).exitAction(DialogButtons.back()).build()).handleResponse("ok", (viewer, identifier, nbtHolder) -> {
            if (nbtHolder == null) {
                return;
            }
            int page = nbtHolder.getInt(JSON_PAGE, warp.getMenuPage());
            int[] slots = nbtHolder.getText(JSON_SLOTS).map(ArrayUtil::parseIntArray).orElse(warp.getMenuSlots());
            warp.setMenuPage(page);
            warp.setMenuSlots(slots);
            warp.markDirty();
            viewer.callback();
        }).build();
    }
}

