/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.warps.dialog.impl;

import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.jspecify.annotations.NonNull;
import su.nightexpress.nightcore.bridge.dialog.wrap.WrappedDialog;
import su.nightexpress.nightcore.bridge.dialog.wrap.body.WrappedDialogBody;
import su.nightexpress.nightcore.bridge.dialog.wrap.button.WrappedActionButton;
import su.nightexpress.nightcore.bridge.dialog.wrap.input.WrappedDialogInput;
import su.nightexpress.nightcore.bridge.dialog.wrap.type.WrappedDialogType;
import su.nightexpress.nightcore.locale.LangEntry;
import su.nightexpress.nightcore.locale.entry.DialogElementLocale;
import su.nightexpress.nightcore.locale.entry.TextLocale;
import su.nightexpress.nightcore.ui.dialog.Dialogs;
import su.nightexpress.nightcore.ui.dialog.build.DialogBases;
import su.nightexpress.nightcore.ui.dialog.build.DialogBodies;
import su.nightexpress.nightcore.ui.dialog.build.DialogButtons;
import su.nightexpress.nightcore.ui.dialog.build.DialogInputs;
import su.nightexpress.nightcore.ui.dialog.build.DialogTypes;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;
import su.nightexpress.sunlight.dialog.Dialog;
import su.nightexpress.sunlight.module.warps.Warp;
import su.nightexpress.sunlight.module.warps.WarpsModule;

public class WarpCommandDialog
extends Dialog<Warp> {
    private static final TextLocale TITLE = LangEntry.builder((String)"Warps.Dialog.WarpCommand.Title").text(WarpCommandDialog.title("Warp", "Command"));
    private static final DialogElementLocale BODY = LangEntry.builder((String)"Warps.Dialog.WarpCommand.Body").dialogElement(400, new String[]{"Enter a " + TagWrappers.YELLOW.wrap("command") + " for quick access to this warp.", "", "This command allows players to quickly teleport to this warp without providing additional arguments.", "", "To apply these changes, we " + TagWrappers.RED.wrap("strongly recommend") + " restarting the server.", "However, you may check the " + TagWrappers.ORANGE.wrap("'Rebuild Commands'") + " box to apply changes 'live', though some minor " + TagWrappers.ORANGE.wrap("side effects") + " may occur."});
    private static final TextLocale INPUT_ENABLED = LangEntry.builder((String)"Warps.Dialog.WarpCommand.Input.Enabled").text("Enabled");
    private static final TextLocale INPUT_COMMAND = LangEntry.builder((String)"Warps.Dialog.WarpCommand.Input.Name").text((String)TagWrappers.SPRITE_ITEM.apply(Material.COMMAND_BLOCK_MINECART) + " Command");
    private static final TextLocale INPUT_REBUILD = LangEntry.builder((String)"Warps.Dialog.WarpCommand.Input.Rebuild").text("Rebuild Commands");
    private static final String JSON_ENABLED = "enabled";
    private static final String JSON_COMMAND = "command";
    private static final String JSON_REBUILD = "rebuild";
    private final WarpsModule module;

    public WarpCommandDialog(@NonNull WarpsModule module) {
        this.module = module;
    }

    @Override
    public @NonNull WrappedDialog create(@NonNull Player player, @NonNull Warp warp) {
        return Dialogs.builder().base(DialogBases.builder((TextLocale)TITLE).body(new WrappedDialogBody[]{DialogBodies.plainMessage((DialogElementLocale)BODY)}).inputs(new WrappedDialogInput[]{DialogInputs.bool((String)JSON_ENABLED, (TextLocale)INPUT_ENABLED).initial(warp.isCommandEnabled()).build(), DialogInputs.text((String)JSON_COMMAND, (TextLocale)INPUT_COMMAND).maxLength(30).initial(warp.getName()).build(), DialogInputs.bool((String)JSON_REBUILD, (TextLocale)INPUT_REBUILD).initial(false).build()}).build()).type((WrappedDialogType)DialogTypes.multiAction((WrappedActionButton[])new WrappedActionButton[]{DialogButtons.ok()}).exitAction(DialogButtons.back()).build()).handleResponse("ok", (viewer, identifier, nbtHolder) -> {
            if (nbtHolder == null) {
                return;
            }
            boolean enabled = nbtHolder.getBoolean(JSON_ENABLED, warp.isCommandEnabled());
            String name = nbtHolder.getText(JSON_COMMAND, warp.getCommandLabel());
            warp.setCommandEnabled(enabled);
            warp.setCommandLabel(name);
            warp.markDirty();
            if (nbtHolder.getBoolean(JSON_REBUILD, false)) {
                this.module.updateWarpCommand(warp);
            }
            viewer.callback();
        }).build();
    }
}

