/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.warmups.impl;

import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.bridge.bossbar.NightBarColor;
import su.nightexpress.nightcore.bridge.bossbar.NightBarFlag;
import su.nightexpress.nightcore.bridge.bossbar.NightBarOverlay;
import su.nightexpress.nightcore.bridge.bossbar.NightBossBar;
import su.nightexpress.nightcore.util.BossBarUtils;
import su.nightexpress.nightcore.util.TimeUtil;
import su.nightexpress.nightcore.util.text.night.NightMessage;
import su.nightexpress.nightcore.util.time.TimeFormats;
import su.nightexpress.nightcore.util.wrapper.UniParticle;
import su.nightexpress.sunlight.module.warmups.WarmupsModule;
import su.nightexpress.sunlight.module.warmups.config.WarmupsConfig;
import su.nightexpress.sunlight.module.warmups.impl.WarmupType;

public abstract class Warmup {
    protected final WarmupsModule module;
    protected final Player player;
    protected final int value;
    protected final long initTime;
    protected final long finishTime;
    protected final Location originLocation;
    protected NightBossBar indicator;
    protected long particleStep;

    public Warmup(@NotNull WarmupsModule module, @NotNull Player player, int countdown) {
        this.module = module;
        this.player = player;
        this.value = countdown;
        this.initTime = System.currentTimeMillis();
        this.finishTime = TimeUtil.createFutureTimestamp((double)countdown);
        this.originLocation = player.getLocation().clone();
    }

    @NotNull
    public abstract WarmupType getType();

    @NotNull
    protected abstract String getIndicatorTitle();

    @NotNull
    protected abstract NightBarColor getIndicatorColor();

    @NotNull
    protected abstract NightBarOverlay getIndicatorStyle();

    private void createIndicator() {
        this.indicator = BossBarUtils.createBossBar((String)"", (NightBarColor)this.getIndicatorColor(), (NightBarOverlay)this.getIndicatorStyle(), (NightBarFlag[])new NightBarFlag[0]);
        this.indicator.addViewer(this.player);
        this.indicator.setProgress(1.0f);
        this.updateIndicator();
    }

    public void updateIndicator() {
        if (this.indicator == null) {
            return;
        }
        long current = System.currentTimeMillis();
        float currentDiff = current - this.initTime;
        float finishDiff = this.finishTime - this.initTime;
        float diff = currentDiff / finishDiff;
        float progress = Math.max(0.0f, 1.0f - diff);
        long timeleft = Math.max(0L, this.finishTime - current);
        String title = this.getIndicatorTitle().replace("%time%", TimeFormats.toSeconds((long)timeleft));
        this.indicator.setProgress(progress);
        this.indicator.setName(NightMessage.parse((String)title));
    }

    private void removeIndicator() {
        if (this.indicator == null) {
            return;
        }
        this.indicator.removeViewers();
        this.indicator.setProgress(0.0f);
        this.indicator = null;
    }

    protected abstract void onInit();

    protected abstract void onComplete();

    protected abstract void onCancel(boolean var1);

    public void onTick() {
        if (((Boolean)WarmupsConfig.WARMUP_PARTICLES_ENABLED.get()).booleanValue()) {
            this.playParticles();
        }
        this.updateIndicator();
    }

    private void playParticles() {
        if (this.particleStep == 30L) {
            this.particleStep = 0L;
        }
        Location location = this.originLocation.clone().add(0.0, 0.05 * (double)this.particleStep, 0.0);
        double x = Math.PI / (Double)WarmupsConfig.EFFECT_X.get() * (double)this.particleStep;
        double z = (double)this.particleStep * (Double)WarmupsConfig.EFFECT_Z1.get() % (Double)WarmupsConfig.EFFECT_Z2.get();
        double y = (Double)WarmupsConfig.EFFECT_Y.get();
        Location left = Warmup.getPointOnCircle(location, true, x, y, z);
        Location right = Warmup.getPointOnCircle(location, true, x - Math.PI, y, z);
        ((UniParticle)WarmupsConfig.WARMUP_PARTICLES_LEFT.get()).play(this.player, left, 0.0, 1);
        ((UniParticle)WarmupsConfig.WARMUP_PARTICLES_RIGHT.get()).play(this.player, right, 0.0, 1);
        ++this.particleStep;
    }

    public boolean isMoved() {
        return this.player.getLocation().distance(this.originLocation) > (Double)WarmupsConfig.WARMUP_MOVEMENT_THRESHOLD.get();
    }

    public boolean isCompleted() {
        return TimeUtil.isPassed((long)this.finishTime);
    }

    public void init() {
        if (((Boolean)WarmupsConfig.BAR_INDICATOR_ENABLED.get()).booleanValue()) {
            this.createIndicator();
        }
        this.onInit();
    }

    public void complete() {
        this.clear();
        this.onComplete();
    }

    public void cancel(boolean silent) {
        this.clear();
        this.onCancel(silent);
    }

    protected void clear() {
        this.removeIndicator();
    }

    @NotNull
    public Player getPlayer() {
        return this.player;
    }

    public int getValue() {
        return this.value;
    }

    @NotNull
    private static Location getPointOnCircle(@NotNull Location location, boolean doCopy, double x, double z, double y) {
        return (doCopy ? location.clone() : location).add(Math.cos(x) * z, y, Math.sin(x) * z);
    }
}

