/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.texts;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.nightcore.NightPlugin;
import su.nightexpress.nightcore.commands.builder.LiteralNodeBuilder;
import su.nightexpress.nightcore.commands.command.LiteralCommand;
import su.nightexpress.nightcore.commands.command.NightCommand;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.util.FileUtil;
import su.nightexpress.nightcore.util.Players;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.config.PermissionTree;
import su.nightexpress.sunlight.hook.placeholder.PlaceholderRegistry;
import su.nightexpress.sunlight.module.Module;
import su.nightexpress.sunlight.module.ModuleContext;
import su.nightexpress.sunlight.module.texts.TextsDefaults;
import su.nightexpress.sunlight.module.texts.TextsLang;
import su.nightexpress.sunlight.module.texts.TextsPerms;
import su.nightexpress.sunlight.module.texts.command.TextCommandProvider;
import su.nightexpress.sunlight.module.texts.text.Text;

public class TextsModule
extends Module {
    private final Map<String, Text> textByIdMap = new HashMap<String, Text>();
    private final Set<NightCommand> textCommands = new HashSet<NightCommand>();

    public TextsModule(@NotNull ModuleContext context) {
        super(context);
    }

    @Override
    protected void loadModule(@NotNull FileConfig config) {
        ((SunLightPlugin)this.plugin).injectLang(TextsLang.class);
        this.loadTexts();
    }

    @Override
    protected void unloadModule() {
        this.textCommands.forEach(NightCommand::unregister);
        this.textCommands.clear();
        this.textByIdMap.clear();
    }

    @Override
    protected void registerCommands() {
        this.commandRegistry.addProvider("texts-text", new TextCommandProvider((SunLightPlugin)this.plugin, this));
        this.textByIdMap.values().forEach(text -> {
            LiteralCommand command = NightCommand.literal((NightPlugin)((NightPlugin)this.plugin), (String)text.getId(), builder -> ((LiteralNodeBuilder)((LiteralNodeBuilder)builder.description(text.getDescription())).permission(text.getPermission())).executes((context, arguments) -> {
                this.showText(context.getSender(), (Text)text);
                return true;
            }));
            if (command.register()) {
                this.textCommands.add((NightCommand)command);
            }
        });
    }

    @Override
    protected void registerPermissions(@NotNull PermissionTree root) {
        root.merge(TextsPerms.MODULE);
    }

    @Override
    public void registerPlaceholders(@NotNull PlaceholderRegistry registry) {
    }

    private void loadTexts() {
        Path textDir = Path.of(this.getSystemPath() + "/texts/", new String[0]);
        if (!Files.exists(textDir, new LinkOption[0])) {
            TextsDefaults.defaultTexts().forEach((id, function) -> {
                Path textFile = Path.of(textDir.toString(), FileConfig.withExtension((String)id));
                FileConfig config = FileConfig.load((Path)textFile);
                Text text = (Text)function.apply(textFile, id);
                config.edit(text::write);
            });
        }
        FileUtil.findYamlFiles((String)textDir.toString()).forEach(file -> {
            Text text = Text.fromFile(file);
            this.textByIdMap.put(text.getId(), text);
        });
        this.info("Loaded " + this.textByIdMap.size() + " custom texts.");
    }

    @Nullable
    public Text getTextById(@NotNull String id) {
        return this.textByIdMap.get(id.toLowerCase());
    }

    @NotNull
    public Set<Text> getCustomTexts() {
        return Set.copyOf(this.textByIdMap.values());
    }

    public void showText(@NotNull CommandSender sender, @NotNull Text text) {
        List<String> list;
        if (sender instanceof Player) {
            Player player = (Player)sender;
            list = text.getText(player);
        } else {
            list = text.getText();
        }
        List<String> texts = list;
        texts.forEach(line -> Players.sendMessage((CommandSender)sender, (String)line));
    }
}

