/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.tab;

import java.util.Map;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.configuration.AbstractConfig;
import su.nightexpress.nightcore.configuration.ConfigProperty;
import su.nightexpress.nightcore.configuration.ConfigType;
import su.nightexpress.nightcore.configuration.ConfigTypes;
import su.nightexpress.sunlight.SLPlaceholders;
import su.nightexpress.sunlight.module.tab.TabDefaults;
import su.nightexpress.sunlight.module.tab.format.TabLayoutFormat;
import su.nightexpress.sunlight.module.tab.format.TabNameFormat;

public class TabSettings
extends AbstractConfig {
    private static final ConfigType<TabLayoutFormat> TAB_LAYOUT_FORMAT_CONFIG_TYPE = ConfigType.of(TabLayoutFormat::read, FileConfig::set);
    private static final ConfigType<TabNameFormat> TAB_NAME_FORMAT_CONFIG_TYPE = ConfigType.of(TabNameFormat::read, FileConfig::set);
    private final ConfigProperty<Long> playerListUpdateInterval = this.addProperty(ConfigTypes.LONG, "PlayerList.Update-Interval", 20L, new String[]{"Sets the frequently (in game ticks) of selecting and displaying the most suitable format (based on rank, priority, and other parameters) for the player list and player name to the client (the player).", "[Asynchronous]", "[1 second = 20 ticks]", "[Default is 20 ticks]"});
    private final ConfigProperty<Long> playerListSortInterval = this.addProperty(ConfigTypes.LONG, "PlayerList.Sort-Interval", 100L, new String[]{"Sets the frequency (in game ticks) of sorting the player list based on the values in 'Rank-Order'.", "[Asynchronous]", "[1 second = 20 ticks]", "[Default is 100 ticks]"});
    private final ConfigProperty<Map<String, Integer>> playerListRankOrders = this.addProperty(ConfigTypes.forMapWithLowerKeys((ConfigType)ConfigTypes.INT), "PlayerList.Rank-Order", TabDefaults.getDefaultPlayerListRankOrders(), new String[]{"Sets the display order of players in the player list based on their rank.", "Players with the highest values appear at the top of the list.", "For players belonging to multiple groups (ranks), the highest available value is used.", "For players who do not belong to any group (rank) listed here, the '%s' value is used if present; otherwise, it defaults to 0.".formatted("default"), "", "[*] Requires %s OR %s with a compatible Permissions plugin for the feature to work.".formatted("LuckPerms", "Vault")});
    private final ConfigProperty<Map<String, TabLayoutFormat>> playerListLayoutFormats = this.addProperty(ConfigTypes.forMapWithLowerKeys(TAB_LAYOUT_FORMAT_CONFIG_TYPE), "PlayerList.Layout-Format", TabDefaults.getDefaultPlayerListFormats(), new String[]{"Here you can create your own, custom player list formats.", "", "[ SETTINGS DESCRIPTION ]", "\u251c\u2500\u2500 Priority:", "\u2502     -> Sets format priority. When multiple formats are available, the one with the highest priority is used.", "\u251c\u2500\u2500 Worlds:", "\u2502     -> List of worlds, where this format is available. Add '%s' to allow all worlds.".formatted("*"), "\u251c\u2500\u2500 Groups:", "\u2502     -> List of ranks (permission groups) to which this format is available. Add '%s' to allow all ranks.".formatted("*"), "\u2514\u2500\u2500 Header + Footer:", "      -> Sets the text displayed at top (Header) and bottom (Footer) of the player list.", "      [>] Text Formations: https://nightexpressdev.com/nightcore/configuration/text-formation/", "      [>] Placeholders Available:", "          - %s - include dynamic text (animation) from the '%s'.".formatted(SLPlaceholders.ANIMATION.apply("[name]"), "animations.yml"), "          - %s - Player name.".formatted("%player_name%"), "          - %s - Player display (custom) name.".formatted("%player_display_name%"), "          - %s - Player prefix.".formatted("%player_prefix%"), "          - %s - Player suffix.".formatted("%player_suffix%"), "          - %s - Player world.".formatted("%player_world%"), "          - %s - https://wiki.placeholderapi.com/".formatted("PlaceholderAPI"), "", "[*] Requires %s OR %s with a compatible Permissions plugin for the feature to work properly.".formatted("LuckPerms", "Vault")});
    private final ConfigProperty<Map<String, TabNameFormat>> playerListNameFormats = this.addProperty(ConfigTypes.forMapWithLowerKeys(TAB_NAME_FORMAT_CONFIG_TYPE), "PlayerList.Name-Format", TabDefaults.getDefaultListNameFormats(), new String[]{"Here you can create your own, custom player name formats for the player list.", "", "[ SETTINGS DESCRIPTION ]", "\u251c\u2500\u2500 Priority:", "\u2502     -> Sets format priority. When multiple formats are available, the one with the highest priority is used.", "\u251c\u2500\u2500 Ranks:", "\u2502     -> List of ranks (permission groups) to which this format is available. Add '%s' to allow all ranks.".formatted("*"), "\u2514\u2500\u2500 Format:", "      -> Sets the text displayed in the player list for the player.", "      [>] Text Formations: https://nightexpressdev.com/nightcore/configuration/text-formation/", "      [>] Placeholders Available:", "          - %s - include dynamic text (animation) from the '%s'.".formatted(SLPlaceholders.ANIMATION.apply("[name]"), "animations.yml"), "          - %s - Player name.".formatted("%player_name%"), "          - %s - Player display (custom) name.".formatted("%player_display_name%"), "          - %s - Player prefix.".formatted("%player_prefix%"), "          - %s - Player suffix.".formatted("%player_suffix%"), "          - %s - Player world.".formatted("%player_world%"), "          - %s - https://wiki.placeholderapi.com/".formatted("PlaceholderAPI"), "", "[*] Requires %s OR %s with a compatible Permissions plugin for the feature to work properly.".formatted("LuckPerms", "Vault")});

    public long getPlayerListUpdateInterval() {
        return (Long)this.playerListUpdateInterval.get();
    }

    public long getPlayerListSortInterval() {
        return (Long)this.playerListSortInterval.get();
    }

    @NotNull
    public Map<String, Integer> getPlayerListRankOrderMap() {
        return (Map)this.playerListRankOrders.get();
    }

    @NotNull
    public Map<String, TabLayoutFormat> getPlayerListLayoutFormatsMap() {
        return (Map)this.playerListLayoutFormats.get();
    }

    @NotNull
    public Map<String, TabNameFormat> getPlayerListNameFormatsMap() {
        return (Map)this.playerListNameFormats.get();
    }
}

