/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.spawns.editor;

import java.util.Comparator;
import java.util.List;
import java.util.stream.IntStream;
import org.bukkit.Material;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.MenuType;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.locale.LangContainer;
import su.nightexpress.nightcore.locale.LangEntry;
import su.nightexpress.nightcore.locale.entry.IconLocale;
import su.nightexpress.nightcore.ui.inventory.item.ItemPopulator;
import su.nightexpress.nightcore.ui.inventory.item.MenuItem;
import su.nightexpress.nightcore.ui.inventory.menu.AbstractMenu;
import su.nightexpress.nightcore.ui.inventory.viewer.ViewerContext;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrapper;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;
import su.nightexpress.sunlight.SunLightPlugin;
import su.nightexpress.sunlight.module.spawns.Spawn;
import su.nightexpress.sunlight.module.spawns.SpawnsModule;
import su.nightexpress.sunlight.module.spawns.config.SpawnsLang;

public class SpawnListEditor
extends AbstractMenu
implements LangContainer {
    private static final IconLocale SPAWN_OBJECT = LangEntry.iconBuilder((String)"Spawns.Editor.SpawnsList.Spawn").accentColor((TagWrapper)TagWrappers.YELLOW).name("%spawn_name%").appendCurrent("ID", "%spawn_id%").br().appendClick("Click to edit").build();
    private final SpawnsModule module;
    private final ItemPopulator<Spawn> spawnPopulator;

    public SpawnListEditor(@NotNull SunLightPlugin plugin, @NotNull SpawnsModule module) {
        super((MenuType)MenuType.GENERIC_9X5, SpawnsLang.EDITOR_TITLE_LIST.text());
        this.module = module;
        plugin.injectLang(this);
        this.spawnPopulator = ItemPopulator.builder(Spawn.class).slots(IntStream.range(0, 36).toArray()).itemProvider((context, spawn) -> spawn.getIcon().hideAllComponents().localized(SPAWN_OBJECT).replace(builder -> builder.with(spawn.placeholders()))).actionProvider(spawn -> context -> this.module.openSpawnSettings(context.getPlayer(), (Spawn)spawn)).build();
        this.load(plugin);
    }

    public void registerActions() {
    }

    public void registerConditions() {
    }

    public void defineDefaultLayout() {
        this.addNextPageItem(Material.ARROW, new int[]{44});
        this.addPreviousPageItem(Material.ARROW, new int[]{36});
    }

    protected void onLoad(@NotNull FileConfig config) {
    }

    protected void onClick(@NotNull ViewerContext context, @NotNull InventoryClickEvent event) {
    }

    protected void onDrag(@NotNull ViewerContext context, @NotNull InventoryDragEvent event) {
    }

    protected void onClose(@NotNull ViewerContext context, @NotNull InventoryCloseEvent event) {
    }

    public void onPrepare(@NotNull ViewerContext context, @NotNull InventoryView view, @NotNull Inventory inventory, @NotNull List<MenuItem> items) {
        List<Spawn> spawns = this.module.getSpawns().stream().sorted(Comparator.comparingInt(Spawn::getPriority).reversed().thenComparing(Spawn::getName)).toList();
        this.spawnPopulator.populateTo(context, spawns, items);
    }

    public void onReady(@NotNull ViewerContext context, @NotNull InventoryView view, @NotNull Inventory inventory) {
    }

    public void onRender(@NotNull ViewerContext context, @NotNull InventoryView view, @NotNull Inventory inventory) {
    }
}

