/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight.module.spawns.dialog.impl;

import java.util.Arrays;
import java.util.function.Function;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.bridge.dialog.wrap.WrappedDialog;
import su.nightexpress.nightcore.bridge.dialog.wrap.body.WrappedDialogBody;
import su.nightexpress.nightcore.bridge.dialog.wrap.button.WrappedActionButton;
import su.nightexpress.nightcore.bridge.dialog.wrap.input.WrappedDialogInput;
import su.nightexpress.nightcore.bridge.dialog.wrap.input.text.WrappedMultilineOptions;
import su.nightexpress.nightcore.bridge.dialog.wrap.type.WrappedDialogType;
import su.nightexpress.nightcore.locale.LangEntry;
import su.nightexpress.nightcore.locale.entry.DialogElementLocale;
import su.nightexpress.nightcore.locale.entry.TextLocale;
import su.nightexpress.nightcore.ui.dialog.Dialogs;
import su.nightexpress.nightcore.ui.dialog.build.DialogBases;
import su.nightexpress.nightcore.ui.dialog.build.DialogBodies;
import su.nightexpress.nightcore.ui.dialog.build.DialogButtons;
import su.nightexpress.nightcore.ui.dialog.build.DialogInputs;
import su.nightexpress.nightcore.ui.dialog.build.DialogTypes;
import su.nightexpress.sunlight.dialog.Dialog;
import su.nightexpress.sunlight.module.spawns.Spawn;
import su.nightexpress.sunlight.module.spawns.model.SpawnRule;

public class SpawnRulesDialog
extends Dialog<Spawn> {
    private static final TextLocale TITLE = LangEntry.builder((String)"Spawns.Dialog.SpawnLoginRules.Title").text(SpawnRulesDialog.title("Spawn", "Login Rules"));
    private static final DialogElementLocale BODY = LangEntry.builder((String)"Spawns.Dialog.SpawnLoginRules.Body").dialogElement(400, new String[]{" "});
    private static final TextLocale INPUT_ENABLED = LangEntry.builder((String)"Spawns.Dialog.SpawnLoginRules.Input.Enabled").text("Enabled");
    private static final TextLocale INPUT_RANKS = LangEntry.builder((String)"Spawns.Dialog.SpawnLoginRules.Input.Ranks").text("Affected Ranks");
    private static final String JSON_ENABLED = "enabled";
    private static final String JSON_RANKS = "ranks";
    private final Function<Spawn, SpawnRule> ruleFunction;

    public SpawnRulesDialog(@NotNull Function<Spawn, SpawnRule> ruleFunction) {
        this.ruleFunction = ruleFunction;
    }

    @Override
    @NotNull
    public WrappedDialog create(@NotNull Player player, @NotNull Spawn spawn) {
        return Dialogs.builder().base(DialogBases.builder((TextLocale)TITLE).body(new WrappedDialogBody[]{DialogBodies.plainMessage((DialogElementLocale)BODY)}).inputs(new WrappedDialogInput[]{DialogInputs.bool((String)JSON_ENABLED, (TextLocale)INPUT_ENABLED).initial(this.ruleFunction.apply(spawn).isEnabled()).build(), DialogInputs.text((String)JSON_RANKS, (TextLocale)INPUT_RANKS).multiline(new WrappedMultilineOptions(Integer.valueOf(10), Integer.valueOf(100))).initial(String.join((CharSequence)"\n", this.ruleFunction.apply(spawn).getRanks())).maxLength(200).build()}).build()).type((WrappedDialogType)DialogTypes.multiAction((WrappedActionButton[])new WrappedActionButton[]{DialogButtons.ok()}).exitAction(DialogButtons.back()).build()).handleResponse("ok", (viewer, identifier, nbtHolder) -> {
            if (nbtHolder == null) {
                return;
            }
            SpawnRule rule = this.ruleFunction.apply(spawn);
            boolean enabled = nbtHolder.getBoolean(JSON_ENABLED, rule.isEnabled());
            String ranksRaw = nbtHolder.getText(JSON_RANKS, String.join((CharSequence)"\n", rule.getRanks()));
            rule.setEnabled(enabled);
            rule.setRanks(Arrays.asList(ranksRaw.split("\n")));
            spawn.markDirty();
            viewer.callback();
        }).build();
    }
}

